#include "c8051F340.h"
#include <intrins.h>
#include <absacc.h>
 
#include<main.h>
#include<mmc_sd\mmc_sd.h>
#include<lcd\lcd.h>

//-----------------------------------------------------------
#ifdef  SPI
unsigned char   GPIO=0x0F;
//IO3    IO2    IO1    IO0
//SCK    SDI    RST    CS
#endif
//-----------------------------------------------------------
//800*480
#define  HDP COL-1  //Hsync Display period   
#define  VDP ROW-1 //Vertical Display period

/*#define  HT  534	  //Horizontal total period = (HT + 1) pixels
#define  HPS 43	  //Horizontal Sync Pulse Start Position = (HPS + 1) pixels	 		 
#define  LPS 10	  //Horizontal Display Period Start Position = LPS pixels		
#define  HPW 42   //Horizontal Sync Pulse Width = (HPW + 1) pixels	

#define  VT 870	 //Vertical Total = (VT + 1) lines
#define  VPS 9  //Vertical Sync Pulse Start Position = VPS lines					  
#define  FPS 3   //Vertical Display Period Start Position = FPS lines				  
#define  VPW 9  //Vertical Sync Pulse Width = (VPW + 1) lines
*/



#define  HT  525	  //Horizontal total period = (HT + 1) pixels
#define  HPS 45	  //Horizontal Sync Pulse Start Position = (HPS + 1) pixels	 		 
#define  LPS 22	  //Horizontal Display Period Start Position = LPS pixels		
#define  HPW 32   //Horizontal Sync Pulse Width = (HPW + 1) pixels	

#define  VT 928	 //Vertical Total = (VT + 1) lines
#define  VPS 40 //Vertical Sync Pulse Start Position = VPS lines					  
#define  FPS 20   //Vertical Display Period Start Position = FPS lines				  
#define  VPW 12  //Vertical Sync Pulse Width = (VPW + 1) lines



/*uint16  HDP=479;
uint16  HT=525;
uint16  HPS=45;
uint16  LPS=22;
uint8   HPW=32;

uint16  VDP=799;
uint16  VT=928;
uint16  VPS=54;
uint16  FPS=41;
uint8   VPW=128;	*/	

//-----------------------------------------------------------

void SPI_SendData(unsigned char i)
{  
   unsigned char n;
   
   for(n=0; n<8; n++)			
   {  
	  if(i&0x80) SPI_DI=1;/*SPI_DI Ϊдȥֵ*/
      	else SPI_DI=0;
      i<<= 1;

	  SPI_CLK=0;_nop_(); _nop_();_nop_();_nop_();
      SPI_CLK=1;//_nop_();_nop_();_nop_();_nop_();
   }
}


void SPI_WriteComm(unsigned char i)
{

		SPI_SendData(0x02);
		SPI_SendData(0x00);
		SPI_SendData(i);
		SPI_SendData(0x00);_nop_(); _nop_();

}

void SPI_WriteData(unsigned char i)
{


	SPI_SendData(i);

}


void SPI_WriteData1(unsigned char i)
{
  SPI_CLK=0;_nop_(); _nop_();
	  if(i&0x80) SPI_D3=1;
      	else SPI_D3=0;

	
		if(i&0x40) SPI_D2=1;
      	else SPI_D2=0;

	
		if(i&0x20) SPI_D1=1;
      	else SPI_D1=0;

	
		if(i&0x10) SPI_DI=1;
      	else SPI_DI=0;
	
      SPI_CLK=1;//_n
	_nop_();_nop_();
		  SPI_CLK=0;_nop_(); _nop_();
		  if(i&0x08) SPI_D3=1;
      	else SPI_D3=0;

				
				
				
		if(i&0x04) SPI_D2=1;
      	else SPI_D2=0;

				
		if(i&0x02) SPI_D1=1;
      	else SPI_D1=0;

				
		if(i&0x01) SPI_DI=1;
      	else SPI_DI=0;
	
      SPI_CLK=1;_nop_();_nop_();




/*
	  if(i&0x80) SPI_DI=1;
      	else SPI_DI=0;
		if(i&0x40) SPI_D1=1;
      	else SPI_D1=0;
		if(i&0x20) SPI_D2=1;
      	else SPI_D2=0;
		if(i&0x00) SPI_D3=1;
      	else SPI_D3=0;
	  SPI_CLK=0;_nop_(); _nop_();_nop_();_nop_();
      SPI_CLK=1;//_nop_();_nop_();_nop_();_nop_();
	
	
		  if(i&0x08) SPI_DI=1;
      	else SPI_DI=0;
		if(i&0x04) SPI_D1=1;
      	else SPI_D1=0;
		if(i&0x02) SPI_D2=1;
      	else SPI_D2=0;
		if(i&0x00) SPI_D3=1;
      	else SPI_D3=0;
		  SPI_CLK=0;_nop_(); _nop_();_nop_();_nop_();
      SPI_CLK=1;//_nop_();_nop_();_nop_();_nop_();


//   unsigned char n;
//   
//   for(n=0; n<8; n++)			
//   {  
//	  if(i&0x80) SPI_DI=1;
//      	else SPI_DI=0;
////		if(i&0x08) SPI_RS=1;
////				else SPI_RS=0;
//     i<<= 1;

//	  SPI_CLK=0;//_nop_(); _nop_();_nop_();_nop_();
//      SPI_CLK=1;//_nop_();_nop_();_nop_();_nop_();
//   }


	*/
}




void init_9c01(void)
{
	SPI_CS=0;

	SPI_RES=1;
	Delay(10);
	SPI_RES=0;
	Delay(200);
	SPI_RES=1;
	Delay(100);
	

	

//  SPI_WriteComm(0xfe);// internal reg enable	
//		SPI_CS=1;
//		_nop_(); _nop_();_nop_();_nop_();
	#if 1
SPI_CS=0;
SPI_WriteComm(0xDE);
SPI_WriteData(0x00);
SPI_CS=1;
	
SPI_CS=0;
SPI_WriteComm(0xDF);
SPI_WriteData(0x98);
SPI_WriteData(0x55);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCE);
SPI_WriteData(0x0D);
SPI_WriteData(0x00);
SPI_CS=1;


SPI_CS=0;
SPI_WriteComm(0xB2);
SPI_WriteData(0x1F);//FMA=6%
SPI_CS=1;


SPI_CS=0;
SPI_WriteComm(0xB7);
SPI_WriteData(0x01);
SPI_WriteData(0x2D);
SPI_WriteData(0x01);
SPI_WriteData(0x55);
SPI_CS=1;


SPI_CS=0;
SPI_WriteComm(0xBB);
SPI_WriteData(0x1B);
SPI_WriteData(0x64);
SPI_WriteData(0xC4);
SPI_WriteData(0x0E);
SPI_WriteData(0x3E);
SPI_WriteData(0xF5);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xBC);
SPI_WriteData(0x03);
SPI_WriteData(0x20);
SPI_WriteData(0xF3);
SPI_WriteData(0xC0);
SPI_CS=1;


SPI_CS=0;
SPI_WriteComm(0xC0);
SPI_WriteData(0x22);
SPI_WriteData(0xA4);
SPI_CS=1;


SPI_CS=0;
SPI_WriteComm(0xC3);
SPI_WriteData(0x00);
SPI_WriteData(0x02);
SPI_WriteData(0x2A);
SPI_WriteData(0x0B);
SPI_WriteData(0x08);
SPI_WriteData(0x48);
SPI_WriteData(0x08);
SPI_WriteData(0x04);
SPI_WriteData(0x62);
SPI_WriteData(0x30);
SPI_WriteData(0x30);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xC4);
SPI_WriteData(0x40);
SPI_WriteData(0x00);
SPI_WriteData(0xAD);
SPI_WriteData(0x68);
SPI_WriteData(0x43);
SPI_WriteData(0x07);
SPI_WriteData(0x04);
SPI_WriteData(0x16);
SPI_WriteData(0x43);
SPI_WriteData(0x07);
SPI_WriteData(0x04);
SPI_CS=1;


//SET_R_GAMMA_Fit_G2.2_0108
SPI_CS=0;
SPI_WriteComm(0xC8); //G2.5
SPI_WriteData(0x3F); //0x3F
SPI_WriteData(0x31); //0x30
SPI_WriteData(0x28); //0x26
SPI_WriteData(0x25); //0x23
SPI_WriteData(0x25); //0x23
SPI_WriteData(0x27); //0x24
SPI_WriteData(0x22); //0x1E
SPI_WriteData(0x22); //0x1E
SPI_WriteData(0x20); //0x1D
SPI_WriteData(0x1F); //0x1C
SPI_WriteData(0x1C); //0x18
SPI_WriteData(0x12); //0x0C
SPI_WriteData(0x0F); //0x09
SPI_WriteData(0x0B); //0x05
SPI_WriteData(0x02); //0x01
SPI_WriteData(0x02); //0x02
SPI_WriteData(0x3F); //0x3F
SPI_WriteData(0x31); //0x30
SPI_WriteData(0x28); //0x27
SPI_WriteData(0x25); //0x23
SPI_WriteData(0x25); //0x23
SPI_WriteData(0x27); //0x24
SPI_WriteData(0x22); //0x1F
SPI_WriteData(0x22); //0x1E
SPI_WriteData(0x20); //0x1C
SPI_WriteData(0x1F); //0x1C
SPI_WriteData(0x1C); //0x18
SPI_WriteData(0x12); //0x0C
SPI_WriteData(0x0F); //0x09
SPI_WriteData(0x0B); //0x05
SPI_WriteData(0x02); //0x01
SPI_WriteData(0x02); //0x02
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD3);
SPI_WriteData(0x28);
SPI_WriteData(0x13);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD7);
SPI_WriteData(0x00);
SPI_WriteData(0x30);
SPI_CS=1;


SPI_CS=0;
SPI_WriteComm(0xD9);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0xFF);
SPI_WriteData(0x00);
SPI_WriteData(0xF0);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xDE);
SPI_WriteData(0x01);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xB7);
SPI_WriteData(0x13);
SPI_WriteData(0xE7);
SPI_WriteData(0x64);
SPI_WriteData(0x39);
SPI_WriteData(0x06);
SPI_WriteData(0x36);
SPI_WriteData(0x19);
SPI_WriteData(0x1C);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xBE);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xC1);
SPI_WriteData(0x05);
SPI_WriteData(0x4A);
SPI_WriteData(0x80);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xC2);
SPI_WriteData(0x00);
SPI_WriteData(0x16);
SPI_WriteData(0xDA);
SPI_WriteData(0xE7);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xC7);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x38);
SPI_WriteData(0x08);
SPI_WriteData(0x08);
SPI_WriteData(0x00);
SPI_WriteData(0x01);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xC8);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x15);
SPI_WriteData(0x3B);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xC9);
SPI_WriteData(0x00);
SPI_WriteData(0x16);
SPI_WriteData(0x06);
SPI_WriteData(0x04);
SPI_WriteData(0x0A);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCA);
SPI_WriteData(0x08);
SPI_WriteData(0x35);
SPI_WriteData(0x16);
SPI_WriteData(0x1F);
SPI_WriteData(0x1F);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCB);
SPI_WriteData(0x01);
SPI_WriteData(0x16);
SPI_WriteData(0x07);
SPI_WriteData(0x05);
SPI_WriteData(0x0B);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCC);
SPI_WriteData(0x09);
SPI_WriteData(0x35);
SPI_WriteData(0x16);
SPI_WriteData(0x1F);
SPI_WriteData(0x1F);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCD);
SPI_WriteData(0x01);
SPI_WriteData(0x16);
SPI_WriteData(0x09);
SPI_WriteData(0x0B);
SPI_WriteData(0x05);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCE);
SPI_WriteData(0x07);
SPI_WriteData(0x15);
SPI_WriteData(0x1F);
SPI_WriteData(0x16);
SPI_WriteData(0x1F);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xCF);
SPI_WriteData(0x00);
SPI_WriteData(0x16);
SPI_WriteData(0x08);
SPI_WriteData(0x0A);
SPI_WriteData(0x04);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD0);
SPI_WriteData(0x00);
SPI_WriteData(0x35);
SPI_WriteData(0x1F);
SPI_WriteData(0x15);
SPI_WriteData(0x1F);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD1);
SPI_WriteData(0x02);
SPI_WriteData(0x30);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD2);
SPI_WriteData(0x02);
SPI_WriteData(0x03);
SPI_WriteData(0x52);
SPI_WriteData(0xDF);
SPI_WriteData(0xDD);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD3);
SPI_WriteData(0x3B);
SPI_WriteData(0x04);
SPI_WriteData(0x48);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD5);
SPI_WriteData(0x10);
SPI_WriteData(0x10);
SPI_WriteData(0x07);
SPI_WriteData(0x07);
SPI_WriteData(0x0F);
SPI_WriteData(0x94);
SPI_WriteData(0x26);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD6);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x40);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xD7);
SPI_WriteData(0x00);
SPI_WriteData(0x00);
SPI_WriteData(0x20);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xDE);
SPI_WriteData(0x02);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xB6);
SPI_WriteData(0x1C);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0xDE);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x4D);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x4E);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x4F);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x4C);
SPI_WriteData(0x01);
SPI_CS=1;
Delay(10);

SPI_CS=0;
SPI_WriteComm(0x4C);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x36);
SPI_WriteData(0x00);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x2A);
SPI_WriteData(0x00);
SPI_WriteData(0x00);//Start_X=0
SPI_WriteData(0x01);
SPI_WriteData(0x68);//End_X=359
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x2B);	
SPI_WriteData(0x00);	
SPI_WriteData(0x00);//Start_Y=0	
SPI_WriteData(0x01);	
SPI_WriteData(0x68);//End_Y=359	
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x35);
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x3A);
SPI_WriteData(0x55);//66=RGB666;55=RGB565
SPI_CS=1;

SPI_CS=0;
SPI_WriteComm(0x11);
SPI_CS=1;
Delay(120);

SPI_CS=0;
SPI_WriteComm(0x29);
SPI_CS=1;
Delay(10);



#endif


}


void LCD_EnterSleep_LCD(void)
{
	SPI_WriteComm(0xfe);
	SPI_WriteComm(0xef);

	SPI_WriteComm(0x28);
	Delay(2000);	
	SPI_WriteComm(0x10);
	
}
void LCD_ExitSleep_LCD(void)
{
	SPI_WriteComm(0xfe);
	SPI_WriteComm(0xef);
	SPI_WriteComm(0x11);
	Delay(120);	
	SPI_WriteComm(0x29);
	
}


void WriteDispData(unsigned char DataH,unsigned char DataL)
{

	unsigned char n;
	SPI_CS=0;

	SPI_RS=1;
//	SPI_DI=1;
DataH=0;
	SPI_CLK=0;
	SPI_CLK=1;
   for(n=0; n<8; n++)			
   {  
//	  if(DataH&0x80) SPI_DI=1;
//      	else SPI_DI=0;
//      DataH<<= 1;
	 if(DataL&0x80) SPI_RS=1;
      	else SPI_RS=0;
      DataL<<= 1;
	  SPI_CLK=0;//_nop_(); _nop_();_nop_();_nop_();
      SPI_CLK=1;//_nop_();_nop_();_nop_();_nop_();
   }
	
	 SPI_CS=1;
}
void BlockWrite(unsigned int Xstart,unsigned int Xend,unsigned int Ystart,unsigned int Yend) reentrant
{
//	Ystart +=32;
//	Yend +=  32;
	SPI_CS=0;
	SPI_WriteComm(0x2a);   
	SPI_WriteData(Xstart>>8);
	SPI_WriteData(Xstart&0xff);
	SPI_WriteData(Xend>>8);
	SPI_WriteData(Xend&0xff);
	SPI_CS=1;
	
	SPI_CS=0;
	SPI_WriteComm(0x2b);   
	SPI_WriteData(Ystart>>8);
	SPI_WriteData(Ystart&0xff);
	SPI_WriteData(Yend>>8);
	SPI_WriteData(Yend&0xff);
	SPI_CS=1;
	
	SPI_CS=0;
	SPI_WriteComm(0x2c);
	SPI_CS=1;
}




void DispColor666(unsigned char red,unsigned char green,unsigned char blue)
{
  unsigned int i,j;	//,DataH,DataL;

	BlockWrite(0,COL-1,0,ROW-1);
	
	
	SPI_CS=0;
	SPI_SendData(0x12);
	SPI_WriteData1(0x00);
	SPI_WriteData1(0x2c);
	SPI_WriteData1(0x00);
	
	for(i=0;i<COL;i++)
		for(j=0;j<ROW;j++)
			{
				  SPI_WriteData1(red<<2);
		     	SPI_WriteData1(green<<2);
					SPI_WriteData1(blue<<2);
			}
	SPI_CS=1;
} 




void DispColor(unsigned int color)
{
  unsigned int i,j,DataH,DataL;
	DataH=(color>>8)&0xff;
	DataL=color&0xff;

	BlockWrite(0,COL-1,0,ROW-1);
	
	
	SPI_CS=0;
	SPI_SendData(0x12);
	SPI_WriteData1(0x00);
	SPI_WriteData1(0x2c);
	SPI_WriteData1(0x00);
	
	
	
	for(i=0;i<COL;i++)
		for(j=0;j<ROW;j++)
			{
				  SPI_WriteData1(color>>8);
		     	SPI_WriteData1(color);
			}
	SPI_CS=1;
} 






 /*******̸********/
void White_Black_Square_NEW(void)   ////TEST ok
{
	unsigned int a=0,b=0,m=0,n=0,i,j;

	BlockWrite(0,COL-1,0,ROW-1);

	for(i=0;i<ROW/16;i++)
		{
	          for(a=0;a<8;a++)
			{
			     for(j=0;j<COL/16;j++)
				{
				   for(n=0;n<8;n++)
						{
						WriteDispData(0x00,0x00);

						}
				for(m=0;m<8;m++)
						{
						WriteDispData(0xff,0xff);
 
						}
				}
			}

	for(b=0;b<8;b++)
	     {
		for(j=0;j<COL/16;j++)
				{
				for(n=0;n<8;n++)
					{
			
						WriteDispData(0xff,0xff);

					}
				for(m=0;m<8;m++)
					{
						WriteDispData(0x00,0x00);

					}
				}
	}
			
   }

}


/*ҽˢ*/
void DispGray(void)
{
   unsigned int i,j,DataH,DataL;
   long int gray;

   for(gray=0;gray<0xffff;gray=gray+0x841)
	{
	DataH=(gray>>8)&0xff;
	DataL=gray&0xff;

	BlockWrite(0,COL-1,0,ROW-1);
	
	for(i=0;i<COL;i++)
		for(j=0;j<ROW;j++)  
			{
				WriteDispData(DataH,DataL);
			}
	
  }
}


 
  /****** 20170117*********/
void White_Line(void)	
{
	unsigned int a=0,b=0,m=0,n=0,i,j;
	
	BlockWrite(0,COL-1,0,ROW-1);
	for(i=0;i<COL;i++)
      {
		for(j=0;j<ROW;j++)  
		{
			if((i<5)||(i>235)||(j<5)||(j>315))
			{
				WriteDispData(0xff,0xff);
			}
			else
			{
				WriteDispData(0x00,0x00);

			}
		}
	}
}


void DispFrame(void)
{
	unsigned int i,j;
	
	BlockWrite(0,COL-1,0,ROW-1);	
//	for(i=0;i<ROW;i++)
//	{ 
//	  for(j=0;j<COL;j++)
//	 
//	  if(i==0||i==(ROW-1)||j==0||j==(COL-1))
//	  {WriteDispData(0xff,0xff);}
//	  else
//	 {WriteDispData(0x00,0x00);}
//	}
  SPI_WriteData(0xf8);SPI_WriteData(0x00);
	for(i=0;i<COL-2;i++){SPI_WriteData(0xFF);SPI_WriteData(0xFF);}
	SPI_WriteData(0x00);SPI_WriteData(0x1f);

	for(j=0;j<ROW-2;j++)
	{
		SPI_WriteData(0xf8);SPI_WriteData(0x00);
		for(i=0;i<COL-2;i++){SPI_WriteData(0x00);SPI_WriteData(0x00);}
		SPI_WriteData(0x00);SPI_WriteData(0x1F);
	}

	SPI_WriteData(0xf8);SPI_WriteData(0x00);
	for(i=0;i<COL-2;i++){SPI_WriteData(0xFF);SPI_WriteData(0xFF);}
	SPI_WriteData(0x00);SPI_WriteData(0x1F);	 
}



/*void DispFrame(void)
{
	unsigned int i,j;
	
	BlockWrite(0,COL-1,0,ROW-3);

	//CS0=0;
	//RD0=1;
	RS=1;
		
	DBH=0xf8,DBL=0x00,WR0=0; WR0=1;
	for(i=0;i<COL-2;i++){DBH=0xFF,DBL=0xFF,WR0=0;WR0=1;}
	DBH=0x00,DBL=0x1f,WR0=0;WR0=1;

	for(j=0;j<ROW-2;j++)
	{
		DBH=0xf8,DBL=0x00,WR0=0;WR0=1;
		for(i=0;i<COL-2;i++){DBH=0x00,DBL=0x00,WR0=0;WR0=1;}
		DBH=0x00,DBL=0x1F,WR0=0;WR0=1;
	}

	DBH=0xf8,DBL=0x00,WR0=0;WR0=1;
	for(i=0;i<COL-2;i++){DBH=0xFF,DBL=0xFF,WR0=0;WR0=1;}
	DBH=0x00,DBL=0x1F,WR0=0;WR0=1;
	
	//CS0=1;

}*/

#ifdef EVAL_PIC
void DispPic(unsigned int code *picture)
{
    data unsigned int *p;
	unsigned int  i,j; //i-row,j-col
	unsigned char n,k; //n-row repeat count,k-col repeat count

	BlockWrite(0,COL-1,0,ROW-1);

	//CS0=0;
	RS =1;
	//RD0=1;

	for(n=0;n<ROW/PIC_HEIGHT;n++)         //n-row repeat count
	{
		for(i=0;i<PIC_HEIGHT;i++)
		{
			p=picture;
			for(k=0;k<COL/PIC_WIDTH;k++) //k-col repeat count
		    {
				for(j=0;j<PIC_WIDTH;j++)
		    	{
						WriteDispData(((*(p+i*PIC_HEIGHT+j))>>8),(*(p+i*PIC_HEIGHT+j)&0xff));

				}

		  	}

			p=picture;
			for(j=0;j<COL%PIC_WIDTH;j++)
		    {
					
					WriteDispData(((*(p+i*PIC_HEIGHT+j))>>8),(*(p+i*PIC_HEIGHT+j)&0xff));
		  	}
		}
	}

	for(i=0;i<ROW%PIC_HEIGHT;i++)
	{
		p=picture;
		for(k=0;k<COL/PIC_WIDTH;k++) //k-col repeat count
	    {
			for(j=0;j<PIC_WIDTH;j++)
	    	{
			    WriteDispData(((*(p+i*PIC_HEIGHT+j))>>8),(*(p+i*PIC_HEIGHT+j)&0xff));
			}

	  	}

		p=picture;
		for(j=0;j<COL%PIC_WIDTH;j++)
	    {
			   WriteDispData(((*(p+i*PIC_HEIGHT+j))>>8),(*(p+i*PIC_HEIGHT+j)&0xff));
	  	}
	}

	//CS0=1;
}
#endif

#ifdef SD_DEMO_PIC
void DispPicFromSD(unsigned char PicNum)
{
	unsigned long Address_S,Address_E;
	unsigned int  i;
	unsigned long k;

    BlockWrite(0,COL-1,0,ROW-1);


	k=(unsigned long)ROW*(unsigned long)COL*2/512;	   
	Address_S = PicNum*k+1;   	   ;		
	Address_E = Address_S+k;
    for(;Address_S<Address_E;Address_S++)
    {  	 CLKSEL = 0x03;
	    MMC_SD_ReadSingleBlock(Address_S);


        for(i=0;i<512;i+=2)
        {	 CLKSEL = 0x03;
            WriteDispData(buffer[i],buffer[i+1]);
        } 

    } 
	//CS0=1; 
	CLKSEL = 0x00;



	
} 

#endif


#ifdef STRING_FUNCTION
void WriteOneDot(unsigned int color)
{ 
	
	//WriteDispData(((color>>8)&0xff),(color&0xff));
		SPI_WriteData(color>>8);
	SPI_WriteData(color);

}

//ascii 32~90(!~Z), (32~47)ո~/,(48~57)0~9,(58~64):~@,(65~126)A~~
//ord 0~95, (48~57)0~9,(65~126)A~z,(33~47)!~/,(58~64):~@
unsigned char ToOrd(unsigned char ch)
{
	if(ch<32)
	{
		ch=95;
	}
	else if((ch>=32)&&(ch<=47)) //(32~47)ո~/
	{
		ch=(ch-32)+10+62;
	}
	else if((ch>=48)&&(ch<=57))//(48~57)0~9
	{
		ch=ch-48;
	}
	else if((ch>=58)&&(ch<=64))//(58~64):~@
	{
		ch=(ch-58)+10+62+16;
	}
	else if((ch>=65)&&(ch<=126))//(65~126)A~~
	{
		ch=(ch-65)+10;
	}
	else if(ch>126)
	{		
		ch=95;
	}

	return ch;
}

void DispOneChar(unsigned char ord,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor)	 // ord:0~95
{													  
   unsigned char i,j,dat;
   data unsigned char *p;
   xdata unsigned int index;

   BlockWrite(Xstart,Xstart+(FONT_W-1),Ystart,Ystart+(FONT_H-1));

   index = ord;

   if(index>95)	   //95:ASCII CHAR NUM
   		index=95;

   index = index*((FONT_W/8)*FONT_H);	 

   p = ascii;
   p = p+index;

   for(i=0;i<(FONT_W/8*FONT_H);i++)
    {
       dat=*p++;
       for(j=0;j<8;j++)
        {
           if((dat<<j)&0x80)
             {
                WriteOneDot(TextColor);
             }      
           else 
             {
                WriteOneDot(BackColor);	  
             }
         }
     }
}

void DispStr(unsigned char *str,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor)
{
	while(!(*str=='\0'))
	{
		DispOneChar(ToOrd(*str++),Xstart,Ystart,TextColor,BackColor);

		if(Xstart>((COL-1)-FONT_W))
		{
			Xstart=0;
		    Ystart=Ystart+FONT_H;
		}
		else
		{
			Xstart=Xstart+FONT_W;
		}

		if(Ystart>((ROW-1)-FONT_H))
		{
			Ystart=0;
		}
	}	
}

void DispInt(unsigned int i,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor)
{
	if(Xstart>((COL-1)-FONT_W*4))
	{
		Xstart=(COL-1)-FONT_W*4;
	}
	
	if(Ystart>((ROW-1)-FONT_H))
	{
		Ystart=(Ystart-1)-FONT_H;
	}
			
	DispOneChar((i>>12)%16,Xstart,Ystart,TextColor,BackColor); //ID value
	DispOneChar((i>>8)%16,Xstart+FONT_W,Ystart,TextColor,BackColor);
	DispOneChar((i>>4)%16,Xstart+FONT_W*2,Ystart,TextColor,BackColor);
	DispOneChar(i%16,Xstart+FONT_W*3,Ystart,TextColor,BackColor); 

}

#endif

#ifdef READ_FUNCTION

#define Read_IC_Mode \
{\
	P1MDOUT |= 0x0; \     
	P1MDIN |= 0x0; \
	DIR=1;  \
}
#define Write_IC_Mode \
{\
	DIR = 0;    \    
	P1MDOUT |= 0xFF;    \     
	P1MDIN |= 0xFF; \
}
#define Delay_Read _nop_();_nop_();_nop_();_nop_();_nop_();_nop_();

	
unsigned int ReadData(void)
{
	unsigned int i=0,dat=0;
	
	
	for(i=0;i<8;i++)
	{

		SPI_CLK=0;
		Read_IC_Mode;
		Delay_Read;
		dat=(dat<<1)|SPI_SDO;
		Write_IC_Mode;
		Delay_Read;
		SPI_CLK=1;
		Delay_Read;
	}
	return dat;
	
}
#endif

unsigned int Read_ID_REG00(void)
{
/*CS should be keep low when read ID*/
	unsigned int Dummy,ID_1,ID_2,ID;
	SPI_CS=0;
				
	SPI_DI=0;//send command flag
	SPI_CLK=0;
	SPI_CLK=1;
	
	SPI_SendData(0x00);//send  command REG
	
	SPI_CLK=0;
	SPI_CLK=1; //send dummy read for first read
	Dummy=ReadData();//second read
	ID_1=ReadData();
	ID_2=ReadData();
	SPI_CS=0;

	ID=ID_1<<8|ID_2;
	
	return ID;

}


unsigned int Read_ID_REG04(void)
{
	unsigned int Dummy,ID_1,ID_2,ID;
	SPI_CS=0;
	Dummy=0;			
		SPI_SendData(0x03);//send  command REG
		SPI_SendData(0x00);//send  command REG
		SPI_SendData(0x04);//send  command REG
		SPI_SendData(0x00);//send  command REG
	

	Dummy=ReadData();//second read
	ID_1=ReadData();
	ID_2=ReadData();
	SPI_CS=1;

	ID=ID_1<<8|ID_2;
	
	return ID;

}

unsigned int Read_ID_REG_DB_DC(void)
{
/*CS should be keep low when read ID*/
	unsigned int ID_1,ID_2,ID;
	SPI_CS=0;
		
	SPI_DI=0;//send command flag
	SPI_CLK=0;
	SPI_CLK=1;

	SPI_SendData(0xDB);//send  command REG
	ID_1=ReadData();// it just get the firt value when use as serial interface! Don't care when parallel!
	//ID_1=ReadData();//parallel can be used,but  serial not!
	SPI_CS=1;

	SPI_CS=0;// cs should be set one time when read out the REG!	
	SPI_DI=0;//send command flag
	SPI_CLK=0;
	SPI_CLK=1;	

	
	SPI_SendData(0xDC);//send  command REG
	ID_2=ReadData();
	//ID_2=ReadData();

	SPI_CS=0;
	ID=ID_1<<8|ID_2;
	
	return ID;

}


unsigned int Read_Register_Value(unsigned int address)
{
	unsigned int  value;
	SPI_CS=0;
		
	SPI_DI=0;//send command flag
	SPI_CLK=0;
	SPI_CLK=1;
	SPI_SendData(address);//send  command REG

	value=ReadData();// it just get the firt value when use as serial interface! Don't care when parallel!
	SPI_CS=0;

	return value;

}


unsigned char GC9304_AND_GC9305_OTP_read_bit(unsigned int address)
{
    uint8 read_value;
	SPI_WriteComm(0xFE); //enable inter register
	SPI_WriteComm(0xEF);

	SPI_WriteComm(0xE5);              
	SPI_WriteData(0x00);

	SPI_WriteComm(0xE4);
	SPI_WriteData(0x05); //otp_lod=0 ptm0=1 ptm0=0 ptm0=1

	SPI_WriteComm(0xE5);                
	SPI_WriteData(0x04);	 // re=1 wlen=1 blen=0
	
	SPI_WriteComm(0xE5);
	SPI_WriteData(0x1c); // re=1 wlen=1 blen=1
	SPI_WriteComm(0xE6);
	SPI_WriteData(address); //ַ
	SPI_WriteComm(0xE5);
	SPI_WriteData(0x3C); //sa_clk=1 blen=1 wlen=1 re=1
	read_value = Read_Register_Value(0xd5); //FPGA_Driver_Read()ֻҪܹID ˵úͨ   
	return read_value;
}


unsigned char GC9304_AND_GC9305_OTP_read_byte(unsigned char address)
{
	unsigned char otp_bit,otp_data; //
	unsigned int i,j;
	otp_bit = 0;
	otp_data = 0;
	for(i=0;i<8;i++)
		{
			j=i<<5;
			j=j|address;
			otp_bit=GC9304_AND_GC9305_OTP_read_bit(j);
			if(otp_bit)
			{
			otp_bit=otp_bit<<i;
			otp_data=otp_data|otp_bit;
			}
			Delay(1);
		}
	return otp_data;
}


#if 1
void GC9304_READ_LOTID(void)
{

	unsigned long int x; //
	xdata unsigned char otp_value_9304[4];
	xdata char lot_id_9304[5];
	xdata unsigned char wafer_ID_9304[2];
	
	for(x=16;x<=19;x++)
	{
		otp_value_9304[x-16]=GC9304_AND_GC9305_OTP_read_byte(x);
	}
	
	//lot_id_9304[5] = ((otp_value_9304[0]&0xf0)>>4)+0x30;
	lot_id_9304[4] = (otp_value_9304[0]&0x0f)+0x30;
	lot_id_9304[3] = ((otp_value_9304[1]&0xf0)>>4)+0x30;
	lot_id_9304[2] = (otp_value_9304[1]&0x0f)+0x30;
	lot_id_9304[1] = ((otp_value_9304[2]&0xf0)>>4)+0x30;
	lot_id_9304[0] = (otp_value_9304[2]&0x0f)+0x30;
	wafer_ID_9304[1]= (otp_value_9304[3]&0xf0)>>4;
	wafer_ID_9304[0]= otp_value_9304[3]&0x0f;
	Delay(1); //öϵ㣬lot_id_9304wafer_ID_9304ӵwatch1
}
#endif



#if 1
void GC9305_READ_LOTID(void)
{
	unsigned long int x; //
	xdata unsigned char otp_value_9305[7];
	xdata char lot_id_9305[5];
	xdata unsigned char wafer_ID_9305[2];
	xdata unsigned int die_x_9305; //U16
	xdata unsigned int die_y_9305;//U16
	xdata char Year_9305[1];
	
	for(x=25;x<=31;x++)
	{
		otp_value_9305[x-25]=GC9304_AND_GC9305_OTP_read_byte(x);
	}
		//lot_id_9305[5]=65; //λLOT ID Ϊ̶ֵA
		lot_id_9305[4] = (otp_value_9305[5]&0x3f)+55; //map ӦLOT ID 洢λ÷ID иϢ
		lot_id_9305[3] = (otp_value_9305[4]&0x3f)+55;
		lot_id_9305[2] = (otp_value_9305[3]&0x0f)+0x30;
		lot_id_9305[1] =((otp_value_9305[3]>>4) &0x0f)+0x30;//0x30 ΪֱӸλASSIC 
		lot_id_9305[0] =(otp_value_9305[2]&0x0f)+0x30;
	
		Year_9305[0] =((otp_value_9305[2]>>4)&0x0f)+0x30;
	
		wafer_ID_9305[1]= otp_value_9305[6]&0x0f;
		wafer_ID_9305[0]= (otp_value_9305[6]>>4) &0x0f;
	
		die_x_9305 = (otp_value_9305[1]<<8) & 0x300;
		die_x_9305 = die_x_9305 | otp_value_9305[0];
		die_y_9305 = otp_value_9305[1]>>2;
		Delay(1); //öϵ㣬lot_id_9305wafer_ID_9305die_x_9305die_y_9305 ԼYear_9305[0] ӵwatch1
	}
#endif

	
	
	
	
	
	

	
	
	
	
	
	
	
	
	

#if 1//def READ_REG
void DispRegValue(unsigned int RegIndex,unsigned char ParNum)
{
	unsigned char i;
	xdata unsigned int reg_data[20];	

	SPI_CS=0;
				
	SPI_DI=0;
	SPI_CLK=0;
	SPI_CLK=1;
	
	SPI_SendData(RegIndex);
	
	SPI_CLK=0;
	SPI_CLK=1;
	
	if(ParNum>20)
		ParNum=20;
	
	for(i=0;i<ParNum;i++)
	{
		reg_data[i]=ReadData();
	}
	
	//READ REG
	DispStr("READ ID ",0,0,BLACK,WHITE);

	//DispStr("READ REG:0X",0,0,BLACK,WHITE);
	//DispInt(i,FONT_W*11,0,BLACK,WHITE);
    for(i=0;i<ParNum;i++)
	{
		DispStr("0X",0,(FONT_H+1)*(i+1),BLUE,WHITE);
		DispInt(reg_data[i],FONT_W*2,(FONT_H+1)*(i+1),BLUE,WHITE);
	}
}

#endif

#ifdef DEBUG
void DispDebugCode(void)
{
	unsigned int i,j;

	for(i=0,j=0;i<50;i++)
	{		
		while(j<15)
		{
			if(debug_code[i][j]==0xffff)
			{
				j=0;
				break;	
			}

			if(j==0)
			{
				if(debug_code[i][j]==0)
				{
					i=50;
					break;
				}
				else
				{
					SPI_WriteComm(debug_code[i][j]);
				}
			}
			else
			{
				SPI_WriteData(debug_code[i][j]);
			}
			j++;		
		} 

		while(j<15)
		{
			if(debug_code[i][j]==0xffff)
			{
				j=0;
				break;	
			}

			if(j==0)
			{	
				if(debug_code[i][j]==0)
				{
					i=50;
					break;
				}
				else
				{
					SPI_WriteComm(debug_code[i][j]);
				}
					
				DispStr("0X",0,(FONT_H+1)*(j+1),RED,WHITE);
				DispInt(debug_code[i][j],FONT_W*2,(FONT_H+1)*(j+1),RED,WHITE);
			}
			else
			{
				DispStr("0X",0,(FONT_H+1)*(j+1),BLUE,WHITE);
				DispInt(debug_code[i][j],FONT_W*2,(FONT_H+1)*(j+1),BLUE,WHITE);
			}
			j++;		
		}

		WaitKey(); Delay(800);
		
	}
}

void Debug(void)
{
	DispStr("DEBUG CODE",0,0,BLACK,WHITE);
	while(1)
	{
		DispDebugCode();
	}
}
#endif


#ifdef DRAW_FUNCTION
void PutPixel(unsigned int x,unsigned int y,unsigned int color)
{
	BlockWrite(x,x+1,y,y+1);

	CS0=0;
	RD0=1;
	RS=1;
	
	DBH=color>>8;
	DBL=color;  

	WR0=0;  
	WR0=1; 

	WR0=0;  
	WR0=1;

	WR0=0;  
	WR0=1; 

	WR0=0;  
	WR0=1; 
	  
	CS0=1; 	 
}

void DrawLine(unsigned int Xstart,unsigned int Xend,unsigned int Ystart,unsigned int Yend,unsigned int color)
{
	unsigned int i,j;

	BlockWrite(Xstart,Xend,Ystart,Yend);

	for(i=Ystart;i<Yend+1;i++)
	{
		for(j=Xstart;j<Xend+1;j++)
		{
			WriteOneDot(color);
		}
	}
}

void DrawGird(unsigned int color)
{
	unsigned int i;

	for(i=15;i<ROW-1;i=i+16)
	{
		DrawLine(0,COL-1,i,i,color);

	}

	for(i=15;i<COL-1;i=i+16)
	{
		DrawLine(i,i,0,ROW-1,color);
	}

}
#endif

//ARRAY DIFINE
//-------------------------------------------------------------------------
#ifdef DEBUG
unsigned int code debug_code[50][15]=
{

{0xd1,0x00,0x1d,0x0c,END},
{0xd1,0x00,0x1d,0x08,END},
{0xd1,0x00,0x1d,0x07,END},
{0xd1,0x00,0x1d,0x0b,END},

{0},//end

};
#endif

#ifdef CHAR_FONT_W8_H16
//ascii 32~90(!~Z), (32~47)ո~/,(48~57)0~9,(58~64):~@,(65~126)A~~
//ord 0~95, (48~57)0~9,(65~126)A~z,(33~47)!~/,(58~64):~@
unsigned char code ascii[]=
{
//12,Ϊx=8x16 
//0(ord:0)
0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,0x00,0x00,

//(ord:1)~1
0x00,0x00,0x00,0x10,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,

//(ord:2)~2
0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x04,0x04,0x08,0x10,0x20,0x42,0x7E,0x00,0x00,

//(ord:3)~3
0x00,0x00,0x00,0x3C,0x42,0x42,0x04,0x18,0x04,0x02,0x02,0x42,0x44,0x38,0x00,0x00,

//(ord:4)~4
0x00,0x00,0x00,0x04,0x0C,0x14,0x24,0x24,0x44,0x44,0x7E,0x04,0x04,0x1E,0x00,0x00,

//(ord:5)~5
0x00,0x00,0x00,0x7E,0x40,0x40,0x40,0x58,0x64,0x02,0x02,0x42,0x44,0x38,0x00,0x00,

//(ord:0)~6
0x00,0x00,0x00,0x1C,0x24,0x40,0x40,0x58,0x64,0x42,0x42,0x42,0x24,0x18,0x00,0x00,

//(ord:0)~7
0x00,0x00,0x00,0x7E,0x44,0x44,0x08,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,

//(ord:0)~8
0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x42,0x3C,0x00,0x00,

//(ord:0)~9
0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x26,0x1A,0x02,0x02,0x24,0x38,0x00,0x00,

// A~Z,12;  ¶ӦĵΪx=8x16 
//(ord:10)~A 
0x00,0x00,0x00,0x10,0x10,0x18,0x28,0x28,0x24,0x3C,0x44,0x42,0x42,0xE7,0x00,0x00,

//(ord:11)~B  
0x00,0x00,0x00,0xF8,0x44,0x44,0x44,0x78,0x44,0x42,0x42,0x42,0x44,0xF8,0x00,0x00,

//(ord:12)~C  
0x00,0x00,0x00,0x3E,0x42,0x42,0x80,0x80,0x80,0x80,0x80,0x42,0x44,0x38,0x00,0x00,

//(ord:13)~D 
0x00,0x00,0x00,0xF8,0x44,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x44,0xF8,0x00,0x00,

//(ord:14)~E  
0x00,0x00,0x00,0xFC,0x42,0x48,0x48,0x78,0x48,0x48,0x40,0x42,0x42,0xFC,0x00,0x00,

//(ord:15)~F 
0x00,0x00,0x00,0xFC,0x42,0x48,0x48,0x78,0x48,0x48,0x40,0x40,0x40,0xE0,0x00,0x00,

//(ord:16)~G  
0x00,0x00,0x00,0x3C,0x44,0x44,0x80,0x80,0x80,0x8E,0x84,0x44,0x44,0x38,0x00,0x00,

//(ord:17)~H 
0x00,0x00,0x00,0xE7,0x42,0x42,0x42,0x42,0x7E,0x42,0x42,0x42,0x42,0xE7,0x00,0x00,

//(ord:18)~I 
0x00,0x00,0x00,0x7C,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,

//(ord:19)~J  
0x00,0x00,0x00,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0xF0,

//(ord:20)~K 
0x00,0x00,0x00,0xEE,0x44,0x48,0x50,0x70,0x50,0x48,0x48,0x44,0x44,0xEE,0x00,0x00,

//(ord:21)~L  
0x00,0x00,0x00,0xE0,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x42,0xFE,0x00,0x00,

//(ord:22)~M  
0x00,0x00,0x00,0xEE,0x6C,0x6C,0x6C,0x6C,0x54,0x54,0x54,0x54,0x54,0xD6,0x00,0x00,

//(ord:23)~N 
0x00,0x00,0x00,0xC7,0x62,0x62,0x52,0x52,0x4A,0x4A,0x4A,0x46,0x46,0xE2,0x00,0x00,

//(ord:24)~O  
0x00,0x00,0x00,0x38,0x44,0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x44,0x38,0x00,0x00,

//(ord:25)~P  
0x00,0x00,0x00,0xFC,0x42,0x42,0x42,0x42,0x7C,0x40,0x40,0x40,0x40,0xE0,0x00,0x00,

//(ord:26)~Q 
0x00,0x00,0x00,0x38,0x44,0x82,0x82,0x82,0x82,0x82,0xB2,0xCA,0x4C,0x38,0x06,0x00,

//(ord:27)~R  
0x00,0x00,0x00,0xFC,0x42,0x42,0x42,0x7C,0x48,0x48,0x44,0x44,0x42,0xE3,0x00,0x00,

//(ord:28)~S  
0x00,0x00,0x00,0x3E,0x42,0x42,0x40,0x20,0x18,0x04,0x02,0x42,0x42,0x7C,0x00,0x00,

//(ord:29)~T  
0x00,0x00,0x00,0xFE,0x92,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,

//(ord:30)~U 
0x00,0x00,0x00,0xE7,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,

//(ord:31)~V  
0x00,0x00,0x00,0xE7,0x42,0x42,0x44,0x24,0x24,0x28,0x28,0x18,0x10,0x10,0x00,0x00,

//(ord:32)~W  
0x00,0x00,0x00,0xD6,0x92,0x92,0x92,0x92,0xAA,0xAA,0x6C,0x44,0x44,0x44,0x00,0x00,

//(ord:33)~X 
0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x18,0x18,0x18,0x24,0x24,0x42,0xE7,0x00,0x00,

//(ord:34)~Y  
0x00,0x00,0x00,0xEE,0x44,0x44,0x28,0x28,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,

//(ord:35)~Z 
0x00,0x00,0x00,0x7E,0x84,0x04,0x08,0x08,0x10,0x20,0x20,0x42,0x42,0xFC,0x00,0x00,

//(ord:36)~ [  
0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1E,0x00,

//(ord:37)~ '\'
0x00,0x00,0x40,0x40,0x20,0x20,0x10,0x10,0x10,0x08,0x08,0x04,0x04,0x04,0x02,0x02,

//(ord:38)~ ] 
0x00,0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x00,

//(ord:39)~ ^ 
0x00,0x1C,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

//(ord:40)~ _ 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,

//(ord:41)~ `
0x00,0x60,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

//(ord:42)~ a  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x1E,0x22,0x42,0x42,0x3F,0x00,0x00,

//(ord:43)~ b 
0x00,0x00,0x00,0xC0,0x40,0x40,0x40,0x58,0x64,0x42,0x42,0x42,0x64,0x58,0x00,0x00,

//(ord:44)~ c 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x22,0x40,0x40,0x40,0x22,0x1C,0x00,0x00,

//(ord:45)~ d  
0x00,0x00,0x00,0x06,0x02,0x02,0x02,0x1E,0x22,0x42,0x42,0x42,0x26,0x1B,0x00,0x00,

//(ord:46)~ e 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x7E,0x40,0x40,0x42,0x3C,0x00,0x00,

//(ord:47)~ f 
0x00,0x00,0x00,0x0F,0x11,0x10,0x10,0x7E,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,

//(ord:48)~ g
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x44,0x44,0x38,0x40,0x3C,0x42,0x42,0x3C,

//(ord:49)~ h 
0x00,0x00,0x00,0xC0,0x40,0x40,0x40,0x5C,0x62,0x42,0x42,0x42,0x42,0xE7,0x00,0x00,

//(ord:50)~ i  
0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,

//(ord:51)~ j  
0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x1C,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x78,

//(ord:52)~ k 
0x00,0x00,0x00,0xC0,0x40,0x40,0x40,0x4E,0x48,0x50,0x68,0x48,0x44,0xEE,0x00,0x00,

//(ord:53)~ l  
0x00,0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00,

//(ord:54)~ m  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x49,0x49,0x49,0x49,0x49,0xED,0x00,0x00,

//(ord:55)~ n  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDC,0x62,0x42,0x42,0x42,0x42,0xE7,0x00,0x00,

//(ord:56)~ o  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00,

//(ord:57)~ p 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD8,0x64,0x42,0x42,0x42,0x44,0x78,0x40,0xE0,

//(ord:58)~ q  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x22,0x42,0x42,0x42,0x22,0x1E,0x02,0x07,

//(ord:59)~ r 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEE,0x32,0x20,0x20,0x20,0x20,0xF8,0x00,0x00,

//(ord:60)~ s  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x42,0x40,0x3C,0x02,0x42,0x7C,0x00,0x00,

//(ord:61)~ t 
0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x7C,0x10,0x10,0x10,0x10,0x10,0x0C,0x00,0x00,

//(ord:62)~ u 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC6,0x42,0x42,0x42,0x42,0x46,0x3B,0x00,0x00,

//(ord:63)~ v 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x28,0x10,0x10,0x00,0x00,

//(ord:64)~ w 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD7,0x92,0x92,0xAA,0xAA,0x44,0x44,0x00,0x00,

//(ord:65)~ x 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6E,0x24,0x18,0x18,0x18,0x24,0x76,0x00,0x00,

//(ord:66)~ y 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x28,0x18,0x10,0x10,0xE0,

//(ord:67)~ z 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x44,0x08,0x10,0x10,0x22,0x7E,0x00,0x00,

//(ord:68)~ { 
0x00,0x03,0x04,0x04,0x04,0x04,0x04,0x08,0x04,0x04,0x04,0x04,0x04,0x04,0x03,0x00,

//(ord:69)~ |  
0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,

//(ord:70)~ } 
0x00,0x60,0x10,0x10,0x10,0x10,0x10,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x60,0x00,

//(ord:71)~ ~  
0x30,0x4C,0x43,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,


//(ord:72)~ ո 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

//(ord:73)~ !  
0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x18,0x18,0x00,0x00,

//(ord:74)~ " 
0x00,0x12,0x36,0x24,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

//(ord:75)~ #  
0x00,0x00,0x00,0x24,0x24,0x24,0xFE,0x48,0x48,0x48,0xFE,0x48,0x48,0x48,0x00,0x00,

//(ord:76)~ $  
0x00,0x00,0x10,0x38,0x54,0x54,0x50,0x30,0x18,0x14,0x14,0x54,0x54,0x38,0x10,0x10,

//(ord:77)~ % 
0x00,0x00,0x00,0x44,0xA4,0xA8,0xA8,0xA8,0x54,0x1A,0x2A,0x2A,0x2A,0x44,0x00,0x00,

//(ord:78)~ & 
0x00,0x00,0x00,0x30,0x48,0x48,0x48,0x50,0x6E,0xA4,0x94,0x88,0x89,0x76,0x00,0x00,

//(ord:79)~ '  
0x00,0x60,0x60,0x20,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

//(ord:80)~ ( 
0x00,0x02,0x04,0x08,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x08,0x08,0x04,0x02,0x00,

//(ord:81)~ ) 
0x00,0x40,0x20,0x10,0x10,0x08,0x08,0x08,0x08,0x08,0x08,0x10,0x10,0x20,0x40,0x00,

//(ord:82)~ *  
0x00,0x00,0x00,0x00,0x10,0x10,0xD6,0x38,0x38,0xD6,0x10,0x10,0x00,0x00,0x00,0x00,

//(ord:83)~ +  
0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0xFE,0x10,0x10,0x10,0x10,0x00,0x00,0x00,

//(ord:84)~ , 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x20,0xC0,

//(ord:85)~ - 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

//(ord:86)~ . 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,0x00,

//(ord:87)~ /  
0x00,0x00,0x01,0x02,0x02,0x04,0x04,0x08,0x08,0x10,0x10,0x20,0x20,0x40,0x40,0x00,

//(ord:88)~ : 
0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,

//(ord:89)~ ;  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x20,

//(ord:90)~ < 
0x00,0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,

//(ord:91)~ = 
0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,

//(ord:92)~ >  
0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,

//(ord:93)~ ?
0x00,0x00,0x00,0x3C,0x42,0x42,0x62,0x02,0x04,0x08,0x08,0x00,0x18,0x18,0x00,0x00,

//(ord:94)~ @ 
0x00,0x00,0x00,0x38,0x44,0x5A,0xAA,0xAA,0xAA,0xAA,0xB4,0x42,0x44,0x38,0x00,0x00,

//(ord:95)~ 0xff 
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,

};
#endif

#ifdef CHAR_FONT_W16_H21
//ascii 32~90(!~Z), (32~47)ո~/,(48~57)0~9,(58~64):~@,(65~126)A~~
//ord 0~95, (48~57)0~9,(65~126)A~z,(33~47)!~/,(58~64):~@
unsigned char code ascii[]=
{
//16,Ϊx=16x21 
/*--  :  0  --*/  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x31,0x80,0x60,0xC0,
0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x31,0x80,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  1  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x1E,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  2  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x60,0xC0,0x60,0xC0,
0x60,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0xC0,
0x60,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  3  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,
0x01,0x80,0x03,0x00,0x0F,0x00,0x01,0x80,0x00,0xC0,0x00,0xC0,0x60,0xC0,0x60,0xC0,
0x61,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  4  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x80,0x07,0x80,0x07,0x80,0x0F,0x80,
0x1B,0x80,0x1B,0x80,0x33,0x80,0x63,0x80,0x63,0x80,0x3F,0xC0,0x03,0x80,0x03,0x80,
0x03,0x80,0x0F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  5  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x3F,0x00,0x39,0x80,0x30,0xC0,0x00,0xC0,0x00,0xC0,0x60,0xC0,0x60,0xC0,
0x61,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  6  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x18,0xC0,0x30,0xC0,0x30,0x00,
0x60,0x00,0x7F,0x00,0x71,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x30,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  7  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x61,0x80,0x63,0x00,0x03,0x00,
0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  8  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,
0x60,0xC0,0x31,0x80,0x1F,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  9  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x61,0x80,0x60,0xC0,
0x60,0xC0,0x60,0xC0,0x60,0xC0,0x31,0xC0,0x1F,0xC0,0x00,0xC0,0x01,0x80,0x61,0x80,
0x63,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  A  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0E,0x00,0x0E,0x00,0x0F,0x00,
0x1B,0x00,0x1B,0x00,0x1B,0x00,0x31,0x80,0x3F,0x80,0x31,0x80,0x31,0x80,0x60,0xC0,
0x60,0xC0,0xF1,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  B  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x31,0x80,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x31,0x80,0x3F,0x00,0x31,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,
0x30,0xC0,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  C  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xE0,0x18,0xE0,0x30,0x60,0x30,0x60,
0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x60,0x30,0x60,
0x38,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  D  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x31,0x80,0x30,0xC0,0x30,0xC0,
0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0xC0,0x30,0xC0,
0x31,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  E  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x30,0xC0,0x30,0x60,0x30,0x00,
0x31,0x80,0x31,0x80,0x3F,0x80,0x31,0x80,0x31,0x80,0x30,0x00,0x30,0x00,0x30,0x60,
0x30,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  F  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x30,0xC0,0x30,0x60,0x30,0x00,
0x31,0x80,0x31,0x80,0x3F,0x80,0x31,0x80,0x31,0x80,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  G  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x19,0xC0,0x30,0xC0,0x30,0xC0,
0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x61,0xE0,0x60,0xC0,0x30,0xC0,0x30,0xC0,
0x18,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  H  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x30,0xC0,0x3F,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  I  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  J  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xF0,0x01,0x80,0x01,0x80,0x01,0x80,
0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
0x01,0x80,0x61,0x80,0x63,0x00,0x3E,0x00,0x00,0x00,

/*--  :  K  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7B,0xE0,0x30,0xC0,0x31,0x80,0x33,0x00,
0x36,0x00,0x3C,0x00,0x3E,0x00,0x36,0x00,0x33,0x00,0x33,0x00,0x31,0x80,0x31,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  L  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x60,
0x30,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  M  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,0x70,0xE0,0x70,0xE0,0x70,0xE0,
0x79,0xE0,0x79,0xE0,0x79,0xE0,0x7B,0x60,0x6F,0x60,0x6F,0x60,0x6F,0x60,0x66,0x60,
0x66,0x60,0xF6,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  N  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x38,0xC0,0x3C,0xC0,0x3C,0xC0,
0x3C,0xC0,0x36,0xC0,0x36,0xC0,0x36,0xC0,0x33,0xC0,0x33,0xC0,0x31,0xC0,0x31,0xC0,
0x31,0xC0,0x78,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  O  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x30,0xC0,0x60,0x60,
0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x30,0xC0,
0x19,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  P  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x30,0xC0,0x30,0x60,0x30,0x60,
0x30,0x60,0x30,0xC0,0x3F,0x80,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  Q  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x30,0xC0,0x60,0x60,
0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x6E,0x60,0x3B,0xC0,
0x3B,0xC0,0x0F,0x80,0x01,0xE0,0x01,0xC0,0x00,0x00,

/*--  :  R  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x31,0x80,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x31,0x80,0x3F,0x00,0x36,0x00,0x33,0x00,0x33,0x00,0x31,0x80,0x31,0x80,
0x30,0xC0,0x78,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  S  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x31,0xC0,0x60,0xC0,0x60,0xC0,
0x60,0x00,0x30,0x00,0x1C,0x00,0x07,0x00,0x01,0x80,0x00,0xC0,0x60,0xC0,0x60,0xC0,
0x71,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  T  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x66,0x60,0x66,0x60,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  U  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x19,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  V  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF1,0xF0,0x60,0x60,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x19,0x80,0x19,0x80,0x19,0x80,0x19,0x80,0x0F,0x00,0x0F,0x00,0x0F,0x00,
0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  W  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x66,0x60,0x66,0x60,0x66,0x60,
0x66,0xC0,0x37,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x19,0x80,
0x19,0x80,0x19,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  X  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,
0x0F,0x00,0x0F,0x00,0x06,0x00,0x06,0x00,0x0F,0x00,0x0F,0x00,0x19,0x80,0x19,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  Y  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,
0x1B,0x00,0x0F,0x00,0x0F,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  Z  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xE0,0x30,0xC0,0x60,0xC0,0x01,0x80,
0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x60,
0x30,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  [  --*/
0x00,0x00,0x00,0x00,0x0F,0xC0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0xC0,0x00,0x00,

/*--  :  \  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x01,0x80,
0x01,0x80,0x01,0x80,0x00,0xC0,0x00,0xC0,0x00,0x00,

/*--  :  ]  --*/
0x00,0x00,0x00,0x00,0x7E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x7E,0x00,0x00,0x00,

/*--  :  ^  --*/
0x00,0x00,0x00,0x00,0x1E,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  _  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE0,

/*--  :  `  --*/
0x00,0x00,0x00,0x00,0x1C,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  a  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x31,0x80,0x0F,0x80,0x39,0x80,0x61,0x80,0x61,0x80,
0x63,0xE0,0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  b  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x3F,0x80,0x38,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,
0x38,0xC0,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  c  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x61,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  d  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,
0x00,0xC0,0x1F,0xC0,0x31,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0xE0,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  e  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x7F,0xC0,0x60,0x00,0x60,0x00,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  f  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x06,0x60,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  g  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xF0,0x30,0xF0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x1F,0x80,0x30,0x00,
0x3F,0x80,0x30,0xE0,0x60,0x60,0x70,0x60,0x3F,0xC0,

/*--  :  h  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x3F,0x80,0x38,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  i  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  j  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x03,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
0x01,0x80,0x01,0x80,0x01,0x80,0x33,0x00,0x3E,0x00,

/*--  :  k  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x33,0xC0,0x33,0x00,0x36,0x00,0x3C,0x00,0x3E,0x00,0x33,0x00,0x31,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  l  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  m  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xE0,0x77,0x60,0x66,0x60,0x66,0x60,0x66,0x60,0x66,0x60,0x66,0x60,
0x66,0x60,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  n  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0x80,0x38,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  o  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  p  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0x80,0x38,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,
0x38,0xC0,0x3F,0x80,0x30,0x00,0x30,0x00,0x78,0x00,

/*--  :  q  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xC0,0x31,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0xC0,0x1F,0xC0,0x00,0xC0,0x00,0xC0,0x01,0xE0,

/*--  :  r  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7B,0xE0,0x1E,0x60,0x1C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
0x18,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  s  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xC0,0x31,0xC0,0x30,0xC0,0x38,0x00,0x0F,0x00,0x01,0xC0,0x30,0xC0,
0x38,0xC0,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  t  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x3F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0xC0,
0x0C,0xC0,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  u  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x71,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x31,0xE0,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  v  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,0x19,0x80,0x0F,0x00,0x0F,0x00,
0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  w  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x66,0x60,0x66,0xE0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,
0x19,0x80,0x19,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  x  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x0F,0x00,0x06,0x00,0x0F,0x00,0x19,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  y  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7B,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,0x0F,0x00,0x0F,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x0C,0x00,0x3C,0x00,0x38,0x00,

/*--  :  z  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0x80,0x63,0x00,0x66,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0xC0,
0x61,0x80,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  {  --*/
0x00,0x00,0x00,0x00,0x01,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x03,0x00,0x07,0x00,0x0C,0x00,0x07,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x01,0xC0,0x00,0x00,

/*--  :  |  --*/
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,

/*--  :  }  --*/
0x00,0x00,0x00,0x00,0x38,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0E,0x00,0x03,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0C,0x00,0x0C,0x00,0x38,0x00,0x00,0x00,

/*--  :  ~  --*/
0x3C,0x00,0x76,0x30,0x63,0x70,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :     --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  !  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  "  --*/
0x00,0x00,0x00,0x00,0x1F,0x80,0x1F,0x80,0x3F,0x00,0x36,0x00,0x6C,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  #  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x7F,0xE0,
0x18,0xC0,0x18,0xC0,0x18,0xC0,0x31,0x80,0x31,0x80,0x7F,0xE0,0x31,0x80,0x31,0x80,
0x31,0x80,0x31,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  $  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0F,0x80,0x1E,0xC0,0x36,0xC0,0x37,0xC0,
0x36,0x00,0x1E,0x00,0x0E,0x00,0x07,0x00,0x07,0x80,0x06,0xC0,0x3E,0xC0,0x36,0xC0,
0x37,0x80,0x1F,0x00,0x06,0x00,0x06,0x00,0x00,0x00,

/*--  :  %  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xC0,0x6D,0x80,0x6D,0x80,0x6F,0x00,
0x6F,0x00,0x6F,0x00,0x3E,0x00,0x07,0xC0,0x0F,0x60,0x0F,0x60,0x1B,0x60,0x1B,0x60,
0x1B,0x60,0x31,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  &  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x33,0x00,
0x36,0x00,0x3F,0xC0,0x39,0x80,0x79,0x80,0xCF,0x00,0xCF,0x00,0xC7,0x00,0xC6,0x00,
0x67,0x60,0x3D,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  '  --*/
0x00,0x00,0x00,0x00,0x78,0x00,0x78,0x00,0x18,0x00,0x30,0x00,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  (  --*/
0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x03,0x00,0x03,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,
0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x00,

/*--  :  )  --*/
0x00,0x00,0x00,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x00,0x00,

/*--  :  *  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x66,0x60,
0x7F,0xE0,0x1F,0x80,0x06,0x00,0x1F,0x80,0x7F,0xE0,0x66,0x60,0x06,0x00,0x06,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  +  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x7F,0xE0,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  ,  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x78,0x00,0x78,0x00,0x18,0x00,0x30,0x00,0xE0,0x00,

/*--  :  -  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  .  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  /  --*/
0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xC0,0x00,0xC0,0x01,0xC0,0x01,0x80,0x01,0x80,
0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,
0x38,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x00,0x00,

/*--  :  :  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  ;  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,

/*--  :  <  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,
0x18,0x00,0x30,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,
0x01,0x80,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  =  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  >  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,
0x03,0x00,0x01,0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,
0x30,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  ?  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x70,0xC0,0x70,0xC0,
0x00,0xC0,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  :  @  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x19,0xC0,0x30,0xC0,0x37,0xE0,
0x6F,0xE0,0x6D,0xE0,0x79,0xE0,0x7B,0x60,0x7B,0x60,0x7B,0xC0,0x6F,0xC0,0x30,0x60,
0x18,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

//ord:95
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

#endif
#ifdef EVAL_PIC
unsigned  int code pic_eval[]={
//Image size:160 X 160 X 16BPP=51200 bytes.Data format: 1 WORD(1 pixel)=RRRRRGGGGGGBBBBB

0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf79e,0xf71c,0xf6db,0xf6db,0xf71c,0xf77d,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf71c,0xf618,0xfcd3,0xf3cf,
0xeacb,0xe1c7,0xe145,0xe104,0xe904,0xe945,0xe1a7,0xe269,
0xf36d,0xf4b2,0xf699,0xf7ff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffbe,
0xf6db,0xed14,0xfb8e,0xf228,0xe124,0xe061,0xf020,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf000,0xe0a2,0xf249,0xf451,0xee99,0xffbf,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffbe,0xf69a,0xec30,0xfa28,
0xe8c3,0xe800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf000,0xe8a2,0xf269,0xed34,
0xff1b,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xf618,0xeaeb,0xf0a3,0xe800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe820,
0xea8a,0xe555,0xff1c,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xfedb,0xeb4d,0xf082,0xf000,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf861,
0xed75,0xedd7,0xf638,0xffbf,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf554,0xe925,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf514,0xffff,0xffbe,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffde,0xec10,
0xe840,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xe903,0xff1c,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xff7d,0xeb0b,0xf000,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xeb2c,0xffff,0xffff,0xffdf,0xffdf,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf71c,0xea49,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf020,0xecf3,0xf7ff,0xf79e,0xef7e,0xef7d,0xffde,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xfedb,0xe9c7,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xe882,0xe596,0xe7be,0xe71c,0xe71b,0xe75d,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xfe9a,0xf166,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xe0c3,0xe514,0xdf3d,0xdefb,0xde79,
0xef1c,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf638,0xe944,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xe082,0xdbcf,0xd679,0xce38,
0xcc10,0xffbf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf575,0xf0c3,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xe000,0xd9c6,0xdaca,
0xd0c3,0xfe18,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xec51,
0xf061,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xf800,
0xf000,0xf000,0xf000,0xf000,0xe800,0xf000,0xe800,0xe800,
0xe800,0xe2ca,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xf75c,0xeb0c,0xf000,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xe800,0xe800,
0xe800,0xe021,0xfe39,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf638,0xe9c7,0xf000,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xe800,0xe800,0xe2ca,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffdf,0xec91,0xe8c3,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xe800,0xe800,0xe021,0xf638,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xfefc,0xeaeb,0xf000,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xe800,0xe800,0xe269,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffde,0xffdf,0xffdf,0xf7ff,0xf7ff,
0xed75,0xe965,0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf000,0xe840,0xf165,0xf269,
0xeb6d,0xe3cf,0xe430,0xe3f0,0xeb6e,0xf2aa,0xf9a6,0xe861,
0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xe800,0xed95,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xf7bf,0xef7d,0xf7be,0xf7ff,0xeeda,0xeb4d,
0xf062,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xe8e4,0xf36d,0xed96,0xf6fc,0xff9e,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffde,0xff1c,0xedf7,
0xf36e,0xe904,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xe166,0xf73d,0xf7df,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffdf,0xe75d,0xe79d,0xe75d,0xecd3,0xe965,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xe861,0xebae,0xf6db,0xffdf,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf6ba,0xeb2c,0xf000,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xe800,0xe3ef,0xef9e,0xef7d,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf7df,0xdf3c,0xe596,0xea8a,0xf000,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xe965,0xf5d7,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xf492,0xf021,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xe082,0xddb7,0xdf3c,
0xf79e,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xee58,0xe30b,0xe882,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe965,
0xfebb,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf451,0xf000,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf800,0xf000,0xda07,0xd67a,
0xdf5c,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xff7d,
0xec51,0xf104,0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf061,0xf618,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffdf,0xf1a6,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xf000,0xf000,0xf000,0xf000,0xd38d,
0xdf3c,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf575,0xe9e7,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xeb0c,0xf7ff,
0xefdf,0xf7bf,0xffbf,0xffdf,0xffdf,0xffdf,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffdf,0xf7df,0xf7ff,0xf40f,0xf000,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf000,0xf800,0xf000,0xf800,0xe041,
0xe5b6,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf69a,0xeaeb,0xf041,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe534,0xefdf,
0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf7bf,
0xf7be,0xf7be,0xf7be,0xf7be,0xf7be,0xf7be,0xf7be,0xf7be,
0xf7be,0xf7be,0xf79e,0xf79d,0xefff,0xf431,0xf000,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf000,0xf000,0xf800,0xf800,0xf000,
0xe9c7,0xff9d,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xff9e,0xf471,0xe8e3,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe596,0xef7e,
0xef3d,0xef5d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef9d,
0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
0xef7d,0xef7d,0xef5d,0xef5d,0xefbe,0xf249,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,0xf800,0xf800,
0xf000,0xeb8e,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf6bb,0xea89,0xf000,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xdcb3,0xe75d,
0xe71c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xef5d,0xe73c,
0xef5d,0xef5d,0xef5d,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
0xe73d,0xe73c,0xe71c,0xe7be,0xe575,0xe841,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xe820,0xf534,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf596,0xe924,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe248,0xdefc,
0xd6db,0xdedb,0xdefb,0xdefb,0xe6fc,0xdefb,0xdefb,0xe71c,
0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xdefb,0xdefb,
0xdefb,0xdedb,0xdf3d,0xde59,0xe945,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf800,0xe0a2,0xf69a,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xecf3,
0xf082,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe820,0xdc93,
0xd71c,0xd6ba,0xd6ba,0xd6ba,0xdeda,0xd6db,0xdebb,0xd6db,
0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd6ba,0xd6ba,
0xd6ba,0xd71c,0xddf7,0xe186,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xe9c7,0xff5d,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xed14,0xf040,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xe8a2,
0xd4d3,0xcedb,0xce9a,0xceba,0xce99,0xd69a,0xd699,0xd69a,
0xd699,0xd69a,0xd69a,0xd699,0xd699,0xce79,0xceba,0xceba,
0xceba,0xdcb2,0xe124,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xf000,0xeb0c,0xffdf,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xf5b6,0xf061,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xe082,0xdb6e,0xcdf7,0xce9a,0xceba,0xce9a,0xc69a,0xce7a,
0xc699,0xce79,0xce9a,0xc69a,0xcebb,0xceba,0xce58,0xdd34,
0xe2aa,0xe841,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xe8a3,0xe30c,0xe2ab,0xe904,0xf000,
0xf800,0xf800,0xf800,0xf800,0xf000,0xf451,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf6ba,0xe8e3,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xe800,0xe145,0xdb0c,0xccd3,0xc596,0xc618,0xc638,
0xc638,0xc638,0xc638,0xc5d7,0xc534,0xd3ef,0xe249,0xe0a2,
0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf020,0xed34,0xffff,0xffff,0xfebb,0xec30,
0xe8a2,0xf800,0xf800,0xf800,0xf800,0xe841,0xf596,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xff9e,0xe9c7,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf000,0xe881,0xe904,0xe1c7,0xda28,
0xda28,0xda28,0xd9e7,0xe145,0xe8a2,0xe800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf061,0xf6ba,0xffff,0xffff,0xffff,0xffff,
0xf5f7,0xe8e3,0xf800,0xf800,0xf800,0xf800,0xe8a3,0xfe79,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xebef,0xf000,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xe554,0xefdf,0xf7be,0xf7df,0xf7bf,
0xf7ff,0xec92,0xe800,0xf800,0xf800,0xf800,0xf800,0xe985,
0xff3c,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xf658,0xe841,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xda29,0xe6fb,0xe73c,0xe73c,0xe73c,
0xe75d,0xe679,0xe8a3,0xf800,0xf000,0xf000,0xf800,0xf000,
0xea8a,0xffbe,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xea49,0xf000,0xf000,0xf000,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xe820,0xd3af,0xcefb,0xd6db,0xd69a,
0xd69a,0xce59,0xe145,0xf800,0xf800,0xf800,0xf800,0xf000,
0xf000,0xf3ef,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf5d7,0xe800,0xf000,0xf000,0xf000,0xf000,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xe840,0xd38e,0xc5f8,0xbe79,
0xbe79,0xc596,0xe0c3,0xf800,0xf800,0xf000,0xf800,0xf000,
0xf000,0xe820,0xf596,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xe269,0xe800,0xf000,0xe800,0xf000,0xf000,0xf000,
0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xe800,0xd1a6,0xbbae,
0xb410,0xca49,0xe800,0xf000,0xf800,0xf800,0xf000,0xf800,
0xf000,0xf000,0xe124,0xff3c,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf6ba,0xe021,0xe000,0xe800,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xe820,
0xe841,0xe800,0xf000,0xf800,0xf800,0xf800,0xf800,0xf000,
0xf000,0xf000,0xf000,0xeb8d,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xe430,0xd800,0xe800,0xe800,0xe800,0xe800,0xf000,0xf000,
0xf000,0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xe061,0xfe9a,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xe208,0xd800,0xe800,0xe800,0xe800,0xe800,0xe800,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf800,0xf800,0xf000,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,0xf000,
0xf800,0xf800,0xf000,0xf800,0xf000,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf800,0xf800,0xf000,0xf000,
0xf000,0xf000,0xe800,0xf000,0xe38e,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xff3c,
0xd882,0xe000,0xe000,0xe000,0xe800,0xe800,0xe800,0xe800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf800,0xf800,0xf000,
0xe000,0xe800,0xf000,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf800,0xf800,0xf800,0xf000,0xf800,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf800,0xf000,0xf000,0xf000,0xf000,
0xf000,0xe800,0xf000,0xe800,0xd8c3,0xff3c,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xedd7,
0xd000,0xd800,0xe000,0xe000,0xe000,0xe800,0xe800,0xe800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xe861,0xea8a,
0xe471,0xe4f3,0xeb6d,0xe8a2,0xf000,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xe800,0xe800,0xe800,0xecf4,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc71,
0xd000,0xd800,0xe000,0xe000,0xe000,0xe800,0xe800,0xe800,
0xe800,0xe800,0xf000,0xf000,0xe800,0xe1c7,0xedd7,0xffbe,
0xffff,0xffff,0xffff,0xf618,0xe8e3,0xf000,0xf000,0xf000,
0xf800,0xf800,0xf000,0xf000,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
0xf800,0xf800,0xf800,0xf800,0xf800,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xe800,0xe800,0xe800,0xe800,0xe800,0xda8a,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xdb4d,
0xc800,0xd800,0xd800,0xe000,0xe000,0xe000,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe1a7,0xff3c,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xecb3,0xe000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xe800,0xe800,0xe800,0xe800,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xe800,0xe800,0xe800,0xf000,0xe800,0xf000,0xe800,0xf000,
0xe800,0xe800,0xe800,0xe800,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xe800,0xf000,0xf000,0xf000,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xd8a3,0xff1b,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xdaeb,
0xc800,0xd800,0xd800,0xd800,0xe000,0xe000,0xe000,0xe000,
0xe800,0xe800,0xe800,0xe021,0xedf7,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xeefb,0xe082,0xe800,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xf000,0xf000,0xf000,
0xf000,0xf000,0xe800,0xf000,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe000,0xf575,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xda8a,
0xc800,0xd000,0xd000,0xd800,0xd800,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xd9c7,0xef9e,0xef7d,0xf79d,0xf79e,
0xf79e,0xf79e,0xef7d,0xef7d,0xdedb,0xd8e3,0xe800,0xe800,
0xe800,0xe800,0xe800,0xf000,0xe800,0xf000,0xf000,0xf000,
0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe000,0xe000,0xe000,0xdb8e,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xda49,
0xc000,0xd000,0xd000,0xd000,0xd800,0xd800,0xd800,0xd800,
0xd800,0xe000,0xd800,0xd36d,0xdf3c,0xdefb,0xe71c,0xe73c,
0xe73c,0xe71c,0xe73c,0xe6fb,0xd659,0xd0c3,0xe000,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe000,0xe800,0xe800,0xe800,
0xe800,0xe000,0xe800,0xe000,0xe000,0xe800,0xe800,0xe800,
0xe000,0xe000,0xe000,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xd1e7,0xffde,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd289,
0xc000,0xd000,0xd000,0xd000,0xd000,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd000,0xcbcf,0xd6ba,0xce9a,0xd6ba,0xd6ba,
0xd6da,0xd6ba,0xd69a,0xd6ba,0xcd54,0xd040,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe800,0xe000,0xe800,0xe800,0xe800,
0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,0xe800,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe800,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xd0c3,0xff1b,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd2eb,
0xb800,0xc800,0xc800,0xd000,0xd000,0xd800,0xd800,0xd800,
0xd800,0xd000,0xd000,0xc34c,0xc639,0xc618,0xc638,0xc638,
0xce58,0xce59,0xc638,0xc679,0xc34d,0xd000,0xe000,0xd800,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xd800,0xe000,
0xe000,0xe000,0xd800,0xe000,0xe000,0xe000,0xe000,0xd800,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xd000,0xfe18,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd32d,
0xb800,0xc800,0xc800,0xc800,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd800,0xd000,0xb9c7,0xadb6,0xb5b6,0xb5b6,0xbdb6,
0xbdd7,0xbdd7,0xb5d7,0xb5b6,0xc124,0xd000,0xd800,0xd800,
0xd800,0xd800,0xd800,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xe000,0xd800,0xd800,0xe000,0xe000,0xe000,0xd800,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xd800,0xe000,0xd800,
0xd800,0xd800,0xd800,0xd800,0xe000,0xe000,0xe000,0xe000,
0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd000,0xed34,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd431,
0xb000,0xc000,0xc000,0xc800,0xc800,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xc042,0x9c30,0x9d55,0xa514,0xad34,
0xad34,0xa535,0xa5b5,0xb30c,0xc800,0xd000,0xd000,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd000,0xc800,0xd020,0xd000,0xd000,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd000,0xd000,0xd000,0xd000,0xd800,0xd800,0xd000,0xe410,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xddb6,
0xb000,0xb800,0xc000,0xc000,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xa925,0x93f0,0x8cd2,0x8cd3,
0x8cf3,0x9cf4,0xa38e,0xb861,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd800,0xd000,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd000,0xd800,0xd800,0xd000,0xd000,0xd800,0xd000,0xd020,
0xda8a,0xe491,0xe596,0xdd55,0xdbef,0xd965,0xd000,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,0xd800,
0xd000,0xd000,0xd000,0xd800,0xd000,0xd000,0xd000,0xd36d,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xef1c,
0xb061,0xb800,0xb800,0xc000,0xc000,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc000,0xa8c3,0x9248,0x930c,
0x932c,0x9a28,0xb841,0xc800,0xc800,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd0a2,0xe534,
0xf7be,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xef1c,0xdb2c,0xc800,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xc800,0xcaca,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,
0xb9e7,0xa800,0xb800,0xb800,0xc000,0xc000,0xc000,0xc800,
0xc000,0xc800,0xc800,0xc000,0xc800,0xc800,0xc000,0xb820,
0xb820,0xc800,0xc800,0xc800,0xd000,0xc800,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xc841,0xe534,0xefff,
0xef9d,0xef7d,0xf77d,0xef5d,0xef7d,0xef9e,0xef7d,0xd26a,
0xc800,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc228,
0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xcc50,0xa000,0xb000,0xb000,0xb800,0xb800,0xb800,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc800,0xc800,0xc000,0xc000,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xd000,0xd000,
0xc800,0xc800,0xc800,0xd000,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,
0xc800,0xc800,0xc800,0xc800,0xd000,0xd000,0xd000,0xd000,
0xd000,0xd000,0xd000,0xd000,0xd000,0xc800,0xc800,0xc800,
0xc800,0xd000,0xc800,0xd000,0xc800,0xcb0c,0xef7e,0xe73c,
0xe73c,0xe73c,0xe73c,0xe71c,0xe71c,0xdefb,0xdf3d,0xddb6,
0xc061,0xd000,0xc800,0xd000,0xc800,0xc800,0xd000,0xc800,
0xd000,0xd000,0xd000,0xd000,0xd000,0xd000,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xb9e7,
0xf79e,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xef1c,0xa082,0xa800,0xb000,0xb000,0xb800,0xb800,0xb800,
0xb800,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc841,0xd5b6,0xdf3c,0xdefa,
0xdedb,0xdedb,0xd6db,0xdedb,0xdebb,0xd6da,0xd6ba,0xd6ba,
0xc965,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc000,0xc800,0xc800,0xc000,0xc000,0xb228,
0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xc3cf,0x9800,0xa800,0xb000,0xb000,0xb000,0xb000,
0xb800,0xb800,0xb800,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc800,0xc000,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc000,0xc186,0xdeba,0xd69a,0xd69a,
0xd69a,0xd69a,0xd69a,0xd699,0xce99,0xce79,0xce79,0xce9a,
0xc9e7,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc000,0xc000,0xc000,0xc000,0xc000,0xb800,0xb800,0xc34d,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf75d,0xa124,0x9800,0xa800,0xa800,0xb000,0xb000,
0xb000,0xb000,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xc000,0xc000,0xb800,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,0xc800,
0xc800,0xc000,0xc000,0xc000,0xba8a,0xd679,0xce59,0xce58,
0xce59,0xce59,0xc658,0xc639,0xc638,0xc618,0xc618,0xc618,
0xb965,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xb800,0xb800,0xb800,0xb000,0xdc92,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xd576,0x8800,0xa000,0xa800,0xa800,0xa800,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xba89,0xce38,0xc618,0xbe18,
0xc617,0xc618,0xbdf7,0xbdf8,0xbdf7,0xbdd7,0xbdf7,0xbd34,
0xb882,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xb800,0xb800,0xb800,0xb800,0xb000,0xa800,0xedb7,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xbc30,0x8000,0x9000,0xa800,0xa000,
0xa800,0xa800,0xa800,0xb000,0xb000,0xb000,0xb000,0xb800,
0xb000,0xb000,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xb800,0xb9e8,0xbdd6,0xb5d7,0xbdd7,
0xb5b6,0xb5b6,0xb5b6,0xb596,0xadb6,0xad75,0xadd7,0xbaec,
0xb800,0xc000,0xb800,0xc000,0xc000,0xc000,0xc000,0xc000,
0xc000,0xc000,0xc000,0xc000,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb000,0xb000,0xa881,0xf6fb,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xbc51,0x7861,0x8000,0x9800,
0xa000,0xa000,0xa800,0xa800,0xa800,0xb000,0xb000,0xb000,
0xb000,0xb800,0xb000,0xb000,0xb000,0xb800,0xb000,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xc000,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xc000,0xb800,0xc000,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xc000,0xc000,0xb800,0xb800,0xb0a2,0xb514,0xad95,0xad75,
0xad55,0xad55,0xad55,0xad55,0xa534,0xa575,0xac71,0xb082,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb000,
0xb000,0xb800,0xb000,0xb000,0xa800,0xa800,0xaa28,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xd618,0x9249,0x7800,
0x8800,0x9800,0xa000,0xa000,0xa000,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xa2ec,0xa596,0xa514,
0xa514,0xa513,0x9d13,0x9cf3,0x9d14,0xa451,0xa924,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb000,0xb000,
0xb000,0xb000,0xb000,0xa800,0xa800,0xa000,0xcc71,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xcd14,
0x81a6,0x7000,0x8800,0x9800,0x9800,0xa000,0xa000,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb800,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb800,0xb000,0xb000,0xb000,0xb800,
0xb000,0xb800,0xb000,0xb800,0xb000,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,0xb800,
0xb800,0xb800,0xb800,0xb800,0xb000,0xa861,0xa38e,0x9514,
0x94f3,0x8cd3,0x94f3,0x9492,0x9b4d,0xa0e3,0xb000,0xb800,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xa800,0xa800,0xa800,0xa000,0x9862,0xf6da,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf7be,0xbcb2,0x81a6,0x7820,0x8000,0x9000,0x9800,0x9800,
0xa000,0xa000,0xa000,0xa800,0xa000,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xa841,0x9a28,
0x9aec,0x9b2c,0x9a8a,0xa165,0xa800,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xb000,0xb000,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa000,0xa000,0x9000,0xaaeb,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xf77d,0xc4d3,0x89c7,0x7000,0x7800,0x8000,
0x9000,0x9000,0x9800,0x9800,0x9800,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xb000,0xa800,0xa800,0xa800,0xb000,
0xb000,0xb000,0xa800,0xb000,0xb000,0xb000,0xb000,0xb000,
0xa800,0xa800,0xa800,0xa800,0xb000,0xb000,0xb000,0xb000,
0xa800,0xb000,0xa800,0xb000,0xa800,0xa800,0xb000,0xa800,
0xa800,0xa800,0xa800,0xb000,0xb000,0xb000,0xb000,0xb000,
0xb000,0xb000,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa000,
0xa000,0xa000,0xa000,0x9800,0x9040,0xee58,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf77d,0xc555,0x92aa,0x70e3,
0x6000,0x6000,0x7000,0x8000,0x8800,0x8800,0x9000,0x9800,
0x9800,0x9800,0x9800,0xa000,0xa000,0xa000,0xa000,0xa000,
0xa000,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xb000,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa000,0xa000,0xa000,0xa000,0xa000,
0xa000,0x9800,0x9800,0x8800,0xb36d,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xe6ba,
0xc575,0xac2f,0x8a4a,0x7805,0x6803,0x7001,0x7000,0x7800,
0x8800,0x8800,0x9000,0x9000,0x9800,0x9800,0x9800,0x9800,
0x9800,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa800,0xa000,0xa800,0xa000,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,
0xa800,0xa800,0xa000,0xa800,0xa000,0xa800,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0x9800,0x9800,
0x9800,0x9800,0x8800,0x9145,0xf73d,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xfe9f,0xca19,0xa875,0x9090,0x782c,0x6828,0x6005,
0x6003,0x6801,0x7000,0x7800,0x8000,0x8800,0x8800,0x9000,
0x9000,0x9000,0x9000,0x9800,0x9800,0x9800,0x9800,0x9800,
0x9800,0x9800,0x9800,0xa000,0x9800,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa800,0xa000,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,
0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9000,
0x9000,0x8800,0x8061,0xde18,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xeddd,0xc8f8,0xb998,0xb456,0x92d2,0x8811,0x8011,0x700e,
0x602b,0x5808,0x5006,0x5005,0x5803,0x6801,0x6800,0x7800,
0x7800,0x8000,0x7800,0x8000,0x8800,0x8800,0x8800,0x9000,
0x9000,0x9000,0x9000,0x9000,0x9000,0x9800,0x9000,0x9800,
0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,
0x9800,0x9800,0xa000,0xa000,0x9800,0x9800,0xa000,0xa000,
0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0x9800,
0x9800,0x9800,0x9800,0xa000,0xa000,0xa000,0xa000,0xa000,
0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,
0x9000,0x9800,0x9800,0x9000,0x9000,0x9000,0x9000,0x8800,
0x7800,0x7062,0xcd34,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf5de,
0xc8d9,0xb817,0xac16,0x8d31,0x6a6d,0x780e,0x680e,0x600c,
0x580b,0x500a,0x480a,0x4009,0x4008,0x4007,0x4807,0x5806,
0x6845,0x7966,0x7164,0x6861,0x6000,0x6000,0x6000,0x6000,
0x6800,0x7000,0x7000,0x8000,0x8000,0x8000,0x8800,0x8800,
0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9800,
0x9020,0x9000,0x9000,0x9800,0x9000,0x9000,0x9800,0x9800,
0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,
0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,0x9800,
0x9800,0x9800,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,
0x9000,0x9000,0x9000,0x8800,0x8800,0x8800,0x7800,0x6800,
0x7945,0xcd95,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xef5d,0xdc9b,0xd0ba,
0xb818,0xa815,0x9913,0x8190,0x784f,0x700e,0x600c,0x580b,
0x500a,0x4809,0x4008,0x4007,0x4008,0x4009,0x4809,0x500b,
0x682d,0x9232,0xccf7,0xd5f8,0xc5b5,0xb4f3,0xac72,0xa3cf,
0x930b,0x826a,0x7a07,0x60c2,0x5841,0x6020,0x6020,0x6800,
0x6800,0x7000,0x7800,0x7800,0x7800,0x8000,0x8000,0x8000,
0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,
0x9000,0x8800,0x8800,0x9000,0x9000,0x9000,0x8800,0x9000,
0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,
0x9000,0x9000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,
0x8800,0x8800,0x8000,0x7800,0x6800,0x6000,0x7166,0xa40f,
0xe6fb,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xde7b,0xcb19,0xc839,0xc818,
0xb016,0xa814,0x9813,0x8811,0x780f,0x700e,0x600c,0x580b,
0x4809,0x4008,0x4008,0x3807,0x3807,0x3807,0x4008,0x480a,
0x580b,0x680d,0x8932,0xbb38,0xee7e,0xffff,0xffff,0xffff,
0xffff,0xf79e,0xe73c,0x632c,0x528a,0x5228,0x51e7,0x49a6,
0x4945,0x4904,0x50c3,0x50a2,0x5082,0x5061,0x5841,0x5820,
0x6000,0x6000,0x6000,0x6000,0x5800,0x6000,0x6000,0x6800,
0x6800,0x6800,0x7000,0x7000,0x7000,0x7800,0x7800,0x7800,
0x7800,0x7800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
0x8000,0x8000,0x8000,0x8000,0x8000,0x7800,0x7800,0x7800,
0x7000,0x6800,0x5800,0x68e3,0x92cb,0xbd34,0xef1c,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xee5c,0xc9d9,0xd01b,0xc819,0xb817,
0xa815,0xa014,0x9812,0x8811,0x780f,0x700e,0x600c,0x582b,
0x594b,0x59ab,0x4949,0x3887,0x3807,0x4008,0x4008,0x4009,
0x500a,0x580b,0x600c,0x700e,0x8851,0xbb17,0xf6ff,0xffff,
0xffff,0xffff,0xdefb,0x5b0c,0x5b0b,0x5aeb,0x52ab,0x528a,
0x4a6a,0x4a69,0x4229,0x4228,0x4208,0x39e7,0x41c7,0x41a6,
0x4186,0x4165,0x49a6,0xac71,0xac51,0x9bce,0x934d,0x930c,
0x8aaa,0x8269,0x7208,0x69a6,0x6965,0x6104,0x60a2,0x5882,
0x5861,0x5841,0x5820,0x5800,0x5800,0x6000,0x6000,0x6000,
0x6000,0x6000,0x6000,0x5800,0x5800,0x5800,0x5841,0x6061,
0x71a6,0x9b2c,0xc555,0xe73c,0xffdf,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xf61e,0xd95b,0xd01a,0xc819,0xb818,0xb016,
0xa015,0x9813,0x9012,0x8010,0x7810,0x700d,0x608d,0x8371,
0x8450,0x6b6d,0x52ea,0x4a69,0x38e7,0x3807,0x4008,0x4009,
0x4809,0x500a,0x580b,0x680c,0x700e,0x8010,0x9953,0xeddc,
0xffff,0xffff,0xb596,0x5aca,0x5aeb,0x5acb,0x52aa,0x528a,
0x4a69,0x4a49,0x4228,0x4228,0x4228,0x4228,0x4208,0x4208,
0x4228,0x3a08,0x5b0c,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xf7be,0xef9d,0xef5c,0xe6fb,0xe6ba,
0xde59,0xcdd7,0xbd55,0xb4b2,0xa410,0x938e,0x934d,0x8b2c,
0x936d,0x9b8e,0x9bae,0x9bef,0xa451,0xac92,0xc575,0xe69a,
0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf7df,0xef9f,0xe79e,0xe79e,0xef9e,0xf7df,0xffff,0xffff,
0xffff,0xfd7e,0xd8db,0xd01a,0xc819,0xc018,0xb817,0xa815,
0xa014,0x9813,0x9012,0x8010,0x780f,0x680d,0x79ef,0x9cf3,
0x73ae,0x5aab,0x4208,0x39c7,0x39c7,0x3847,0x4007,0x4008,
0x4809,0x4809,0x500a,0x580b,0x600c,0x680d,0x700f,0x8091,
0xdd7c,0xffff,0x8c91,0x5acb,0x5b0b,0x5acb,0x52aa,0x526a,
0x4a49,0x4a49,0x4228,0x4228,0x4208,0x4208,0x4208,0x4228,
0x4228,0x39e7,0x73ae,0xffdf,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xd77e,0x9e9c,0x75fb,0x65bc,0x555b,
0x451a,0x3cb9,0x3477,0x3436,0x3c36,0x4c76,0x6cf6,0xa5f9,
0xcdbb,0xd8bb,0xd81b,0xc839,0xc198,0xa936,0xa836,0xa815,
0xa014,0x9812,0x8811,0x8010,0x780f,0x680e,0x714e,0x8410,
0x634c,0x4a69,0x31c6,0x2965,0x2986,0x3026,0x3807,0x4008,
0x4008,0x4809,0x500a,0x500a,0x580b,0x584b,0x61ac,0x694d,
0x80d0,0xd5db,0x7bef,0x5aeb,0x5aeb,0x5aab,0x52aa,0x4a69,
0x4a49,0x4a49,0x4228,0x4228,0x4228,0x4208,0x4208,0x4228,
0x4228,0x4208,0x9492,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf7ff,0xb6fe,0x55dd,0x1d1d,0x04bc,0x049b,0x047b,0x047b,
0x0439,0x03f9,0x03d7,0x0396,0x0355,0x0333,0x02f2,0x02f1,
0x1a91,0x5953,0x9895,0xc378,0xb555,0x736e,0x9072,0xa014,
0x9813,0x9012,0x8811,0x8010,0x780f,0x700e,0x600c,0x61ac,
0x5aaa,0x4208,0x3166,0x2925,0x2885,0x3006,0x3807,0x4008,
0x4008,0x4808,0x4809,0x480a,0x500a,0x486a,0x41e8,0x4289,
0x598b,0x79af,0x734e,0x5b0b,0x5aeb,0x52ca,0x528a,0x4a69,
0x4a49,0x4a49,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,
0x4228,0x4208,0xad55,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x4dbd,0x0cfd,0x14fc,0x1cfc,0x04fd,0x04fe,0x04fd,0x04dc,
0x04bc,0x049b,0x047a,0x0439,0x0418,0x03d6,0x0395,0x0374,
0x0333,0x0311,0x028f,0x32ce,0x5b8c,0x5aca,0x790e,0x9813,
0x9813,0x9011,0x8011,0x8010,0x780f,0x700e,0x680d,0x580b,
0x506a,0x40a8,0x3887,0x3827,0x3807,0x4007,0x4008,0x3808,
0x4008,0x4009,0x4008,0x4809,0x4809,0x4809,0x3887,0x2945,
0x4168,0x61cc,0x732d,0x5b0b,0x5acb,0x52aa,0x4a8a,0x4a49,
0x4a49,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,
0x4228,0x4228,0xbdf7,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x5dfe,0xa6ff,0xcf5d,0xc6fc,0x7dfb,0x0d1d,0x04fe,0x04fd,
0x04dd,0x04bc,0x049b,0x047a,0x0459,0x0418,0x03f7,0x03b6,
0x0375,0x0373,0x0312,0x026e,0x09cb,0x3a6a,0x528a,0x696c,
0x8071,0x9012,0x8810,0x8010,0x700e,0x700d,0x680d,0x600c,
0x580b,0x500a,0x4809,0x4809,0x4808,0x4009,0x4008,0x4008,
0x4008,0x4008,0x4008,0x4008,0x4008,0x4809,0x4809,0x3848,
0x4849,0x6a8c,0x6b4d,0x630c,0x5acb,0x52aa,0x4a8a,0x4a69,
0x4a49,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,
0x4a49,0x4a49,0xce59,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffdf,0xf79d,0xef1b,0x357d,0x04fe,0x051e,
0x04fd,0x04dc,0x04dc,0x049b,0x047a,0x0459,0x0438,0x03f7,
0x03b6,0x0395,0x0333,0x02f1,0x026e,0x01cb,0x2209,0x4268,
0x51ca,0x8030,0x8811,0x780f,0x780e,0x700e,0x680d,0x600c,
0x580b,0x500b,0x500a,0x4809,0x4809,0x4809,0x4008,0x4007,
0x3807,0x4007,0x3807,0x3007,0x3807,0x4007,0x4008,0x480a,
0x504a,0x732e,0x632c,0x5b0b,0x5acb,0x52aa,0x4a69,0x4a49,
0x4a49,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,
0x4a49,0x4a69,0xd69a,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffbe,0xef7d,0xd71c,0x255e,0x053e,0x051e,
0x051e,0x04fd,0x04dd,0x04dc,0x049b,0x047a,0x0459,0x0418,
0x03d7,0x03b5,0x0374,0x0332,0x02d0,0x026e,0x01cb,0x09c9,
0x2207,0x590b,0x8030,0x8010,0x780f,0x680d,0x680c,0x600c,
0x580b,0x500a,0x500a,0x4809,0x4809,0x4809,0x4008,0x3807,
0x3807,0x3006,0x3887,0x3908,0x3887,0x3007,0x3007,0x3807,
0x514a,0x6b4d,0x630c,0x5aea,0x5aaa,0x528a,0x4a6a,0x4a49,
0x4a49,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,
0x4a49,0x528a,0xd6ba,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffde,0xf79d,0xf75b,0xf75b,0xff9c,
0xffdd,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf77d,0xef9e,0xef7d,0xef3c,0x8e1c,0x051e,0x053e,0x051e,
0x051e,0x04fd,0x04dd,0x04bc,0x04bc,0x047b,0x045a,0x0418,
0x0417,0x03d6,0x0395,0x0353,0x0312,0x02b0,0x026e,0x01ec,
0x01aa,0x0989,0x48ac,0x604e,0x700e,0x700d,0x600c,0x580c,
0x580b,0x500a,0x500a,0x4809,0x4809,0x4008,0x3807,0x3007,
0x3006,0x30a6,0x4a29,0x4228,0x4207,0x30a6,0x2805,0x3006,
0x59eb,0x6b6d,0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a49,
0x4a49,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,
0x4a69,0x52aa,0xdedb,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf79c,
0xde97,0xbd72,0xac8c,0xa408,0xa3a5,0xa3a4,0xabc3,0xb425,
0xbc67,0xcd0a,0xd5b0,0xe674,0xff59,0xfffe,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xdeda,0xdedb,0xe6da,0xc67a,0x251d,0x051e,0x051e,0x051e,
0x04fe,0x04fd,0x04fc,0x04dc,0x04bb,0x049b,0x047a,0x0459,
0x0418,0x03f7,0x03b5,0x0374,0x0353,0x02f1,0x02af,0x026e,
0x022c,0x01eb,0x01a9,0x0969,0x30ea,0x408b,0x502b,0x580b,
0x580a,0x5009,0x4809,0x4809,0x4008,0x3807,0x3807,0x3006,
0x2805,0x3988,0x4a48,0x31a6,0x2985,0x3126,0x2805,0x3006,
0x62ab,0x632d,0x5aec,0x5acb,0x52aa,0x4a8a,0x4a69,0x4a49,
0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,
0x4a69,0x52aa,0xd6ba,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf77d,0xd615,0xac6c,0x9365,
0x8ae1,0x92e0,0x9b20,0xa340,0xab60,0xb3a0,0xbbc0,0xc3e0,
0xc400,0xcc00,0xcc20,0xd420,0xd482,0xd528,0xee52,0xff7a,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf7ff,0xefdd,0xeffe,0xf7fe,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xc618,0xbdf8,0x9dd9,0x353b,0x04fe,0x051e,0x04fe,0x04fd,
0x04fd,0x04dc,0x04dc,0x04bc,0x049b,0x049b,0x047a,0x0459,
0x0419,0x03f7,0x03d6,0x0395,0x0374,0x0333,0x02f1,0x02af,
0x026e,0x022d,0x020c,0x01ca,0x01a9,0x0189,0x1929,0x28ca,
0x4049,0x500a,0x4809,0x4008,0x4007,0x3807,0x3006,0x3006,
0x2805,0x3967,0x4208,0x2965,0x2124,0x20e4,0x2004,0x3086,
0x6b2d,0x632c,0x5aeb,0x52aa,0x528a,0x4a6a,0x4a69,0x4a49,
0x4228,0x4228,0x4208,0x4228,0x4228,0x4228,0x4228,0x4a49,
0x4a69,0x528a,0xce79,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xef5c,0xbd51,0x9346,0x8aa0,0x92e0,0xa360,
0xaba0,0xb3c0,0xbbe0,0xc400,0xcc20,0xcc40,0xd460,0xdc80,
0xdc80,0xe4a0,0xe4c0,0xecc0,0xeca0,0xe460,0xe460,0xdce3,
0xf62f,0xffbc,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xe7bc,0xb797,0x8f91,0x6f8d,
0x5f6a,0x4f49,0x4f69,0x5f8b,0x6fcd,0x8fd0,0xb7b6,0xe7dc,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x453a,0x351a,0x14bc,0x04fd,0x051e,0x051d,0x04fd,0x04fd,
0x04dd,0x04fc,0x04dc,0x04bc,0x04bc,0x049b,0x047a,0x045a,
0x0438,0x0418,0x03f7,0x03b6,0x0395,0x0354,0x0333,0x02f1,
0x02d0,0x028f,0x024e,0x022d,0x01ec,0x01ca,0x01aa,0x0189,
0x0948,0x20a9,0x4008,0x4008,0x3807,0x3806,0x3006,0x3006,
0x2805,0x2885,0x3986,0x2144,0x18c3,0x1863,0x1803,0x3947,
0x6b4d,0x630c,0x5acb,0x52aa,0x528a,0x4a69,0x4a49,0x4a49,
0x4228,0x4228,0x4208,0x4228,0x4208,0x4228,0x4228,0x4a49,
0x528a,0x528a,0xc638,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xcdf4,0x8b66,0x8280,0x9b00,0xaba0,0xb3c0,0xb3c0,
0xbbe0,0xc400,0xcc40,0xd440,0xd460,0xdc80,0xe4a0,0xe4c0,
0xecc0,0xece0,0xecc0,0xecc1,0xdd05,0xe547,0xe567,0xed03,
0xec80,0xed45,0xff37,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf7fe,0xe79b,0xaf35,0x6ecd,0x3646,0x0e61,0x0700,0x0760,
0x0780,0x07a0,0x07a0,0x07c0,0x07e0,0x07c0,0x0f81,0x37a6,
0x77ce,0xe7dc,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x0d1e,0x04fe,0x04fe,0x04fe,0x051e,0x04fd,0x04fd,0x04fd,
0x04fd,0x04dd,0x049c,0x047b,0x047b,0x047b,0x047b,0x047a,
0x0459,0x0438,0x0418,0x03f7,0x03b6,0x0395,0x0374,0x0333,
0x0312,0x02d0,0x02af,0x026e,0x024d,0x020c,0x01eb,0x01ca,
0x01a9,0x0189,0x1108,0x3028,0x3807,0x3806,0x3006,0x3006,
0x2805,0x2004,0x2064,0x1883,0x1843,0x1803,0x1003,0x4a29,
0x6b4d,0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a49,0x4228,
0x4228,0x4228,0x4208,0x4208,0x4208,0x4228,0x4a49,0x4a69,
0x528a,0x528a,0xb5b6,0xffff,0xffdf,0xffdf,0xffdf,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xef5c,
0xa46c,0x7aa1,0x92e0,0xab80,0xb3c0,0xbbc0,0xc3e0,0xcc20,
0xcc40,0xd460,0xd480,0xdc80,0xe4a0,0xe4c0,0xecc0,0xece0,
0xf500,0xf4e0,0xdd48,0xd615,0xdeb9,0xe71b,0xef3c,0xef3a,
0xf6f6,0xf5c8,0xe504,0xf6f5,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xef7e,0xf79d,0xffbf,
0xffff,0xe7fc,0xcf99,0xb756,0xa714,0x96f2,0x7ecf,0x66ac,
0x4688,0x2de5,0x0d81,0x05a0,0x0620,0x06a0,0x0720,0x0740,
0x0780,0x0780,0x07a0,0x07a0,0x07c0,0x07e0,0x07e0,0x07e0,
0x07c0,0x676c,0xf7de,0xffff,0xffff,0xffff,0xffff,0xffff,
0x153e,0x051d,0x051e,0x04fe,0x04fd,0x04fe,0x04fd,0x04dd,
0x049b,0x24ba,0x4d3a,0x5d3a,0x54f9,0x3498,0x1438,0x0459,
0x045a,0x0459,0x0438,0x03f7,0x03d6,0x03d6,0x0395,0x0374,
0x0353,0x0312,0x02f1,0x02b0,0x028f,0x026e,0x022d,0x020c,
0x01cb,0x01ca,0x01a9,0x0948,0x2847,0x3006,0x3006,0x2805,
0x2805,0x2804,0x2004,0x1804,0x1803,0x1002,0x1823,0x5acb,
0x632c,0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a49,0x4228,
0x4228,0x4228,0x4228,0x4208,0x4208,0x4228,0x4a49,0x4a69,
0x528a,0x528a,0xa514,0xffff,0xffdf,0xffff,0xffdf,0xe71c,
0xc618,0xad55,0xad55,0xad75,0xc639,0xef5d,0xd677,0x8b66,
0x8280,0x9b20,0xaba0,0xb3c0,0xbbe0,0xc400,0xcc40,0xd460,
0xdc80,0xdca0,0xe4c0,0xe4c0,0xece0,0xece0,0xf500,0xf500,
0xfd00,0xed45,0xde98,0xe75e,0xef9e,0xf7bf,0xffff,0xffff,
0xffff,0xfffe,0xf6f4,0xe568,0xf716,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xf79f,0xad55,0xad15,0xcdf8,0xce79,
0x8eb1,0x2e45,0x1642,0x0e21,0x0620,0x0de0,0x05c0,0x0580,
0x0540,0x0560,0x05a0,0x05e0,0x0640,0x06a0,0x06e0,0x0720,
0x0760,0x0780,0x0780,0x07a0,0x07c0,0x07e0,0x07e0,0x07e0,
0x07e0,0x07c0,0x6f8d,0xefde,0xffff,0xffff,0xffff,0xffff,
0x0d3e,0x051e,0x053e,0x051e,0x04fd,0x04fe,0x04bd,0x24da,
0x963c,0xdf1c,0xef3c,0xef1b,0xdeba,0xce38,0x9d56,0x4455,
0x0c17,0x0459,0x0438,0x0418,0x0417,0x03d6,0x03b6,0x0395,
0x0374,0x0353,0x0332,0x02f1,0x02d0,0x028f,0x026e,0x024d,
0x022d,0x020c,0x01eb,0x01ca,0x0948,0x2046,0x3005,0x2805,
0x2805,0x2004,0x1803,0x1002,0x0801,0x0821,0x3166,0x632c,
0x630c,0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a49,0x4228,
0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,0x4a69,
0x528a,0x52aa,0x8c71,0xffff,0xf7be,0xc638,0x8c51,0x736e,
0x634d,0x632d,0x630c,0x5aec,0x5289,0x6aa7,0x82c1,0x8ac0,
0xa340,0xaba0,0xb3c0,0xc3e0,0xc420,0xd440,0xdc60,0xe4a0,
0xe4c0,0xecc0,0xecc0,0xece0,0xece0,0xf500,0xf500,0xfd20,
0xfd00,0xe58a,0xe73c,0xef9e,0xf7be,0xffdf,0xffff,0xffff,
0xffff,0xffff,0xffff,0xf736,0xe569,0xff9a,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xb596,0x4ac9,0x6c4d,0x650c,0x3d67,
0x05a0,0x05c0,0x05e0,0x05c0,0x05a0,0x05a0,0x0580,0x0580,
0x0560,0x0560,0x05a0,0x05e0,0x0640,0x0680,0x06c0,0x0700,
0x0740,0x0760,0x0780,0x07a0,0x07c0,0x07e0,0x07e0,0x07e0,
0x07e0,0x07e0,0x07e0,0x578a,0xdfdb,0xffff,0xffdf,0xffdf,
0x0d5f,0x051e,0x051e,0x051e,0x04fe,0x04dd,0x1cdb,0xcefd,
0xffff,0xffff,0xffbf,0xf7be,0xe75c,0xdefc,0xd679,0xbd95,
0x5413,0x0418,0x0439,0x0439,0x0419,0x0417,0x03f6,0x03b6,
0x0395,0x0374,0x0353,0x0332,0x0311,0x02d0,0x02af,0x028f,
0x026e,0x024e,0x022d,0x01ec,0x01ca,0x0969,0x2046,0x2004,
0x1002,0x1002,0x1043,0x2905,0x5aab,0xa534,0xa514,0x5aeb,
0x630c,0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a49,0x4228,
0x4228,0x4228,0x4228,0x4228,0x4208,0x4228,0x4228,0x4a49,
0x528a,0x52aa,0x7bef,0xe71c,0x94b2,0x738e,0x7bef,0x8c51,
0x8c71,0x8c71,0x8431,0x736c,0x6a83,0x8280,0x9300,0xa360,
0xaba0,0xb3c0,0xc3e0,0xcc20,0xd480,0xdc80,0xe4c0,0xe4c0,
0xece0,0xece0,0xece0,0xf500,0xf500,0xf520,0xfd20,0xfd40,
0xfd20,0xed67,0xe71b,0xef7e,0xf7bf,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xf60e,0xe569,0xffdd,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xefbd,0x9ef3,0x34c7,0x1481,0x0d41,0x05a0,0x05c0,
0x05c0,0x05a0,0x05a0,0x05a0,0x0580,0x0580,0x0560,0x0560,
0x0560,0x0560,0x0580,0x05c0,0x0600,0x0660,0x06a0,0x0700,
0x0740,0x0780,0x07a0,0x07a0,0x07c0,0x07e0,0x07e0,0x07e0,
0x07e0,0x07e0,0x07e0,0x07e0,0x3f86,0xb776,0xef3d,0xef5d,
0x153e,0x051f,0x051e,0x051e,0x04fe,0x049c,0x7ddb,0xffdd,
0xfffe,0xffff,0xf7df,0xf79e,0xef3c,0xdefb,0xce99,0xbdf7,
0x9cd2,0x23d5,0x0439,0x0459,0x0439,0x0438,0x03f7,0x03d6,
0x03b6,0x0395,0x0395,0x0353,0x0333,0x0312,0x02f1,0x02b0,
0x028f,0x022e,0x020c,0x020c,0x020c,0x01eb,0x0928,0x30e6,
0x5a2a,0x7b8f,0xad35,0xdeba,0xffff,0xffff,0x9491,0x5aca,
0x630c,0x5acb,0x52aa,0x528a,0x4a69,0x4a69,0x4a49,0x4228,
0x4228,0x4228,0x4208,0x4228,0x4208,0x4228,0x4228,0x4a69,
0x4a69,0x52aa,0x6b6d,0x8c51,0x8410,0x9cd3,0x9cf3,0xa514,
0xa514,0x9cf4,0x83ed,0x72c2,0x8ac0,0x9b40,0xa360,0xb380,
0xb3e0,0xc400,0xc420,0xd460,0xdc80,0xe4a0,0xe4e0,0xece0,
0xece0,0xece0,0xf500,0xf500,0xf500,0xfd20,0xfd40,0xfd40,
0xfd40,0xf520,0xe654,0xef7e,0xf79d,0xf7be,0xffdf,0xffdf,
0xffdf,0xf7be,0xf79e,0xef7e,0xeed7,0xe4a2,0xee0c,0xfffe,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xb6f6,0x4548,0x04c0,0x0560,0x05c0,0x0580,0x0580,0x0580,
0x0580,0x0580,0x0580,0x0580,0x0560,0x0560,0x0560,0x0540,
0x0540,0x0580,0x0580,0x05a0,0x0600,0x0620,0x0680,0x06c0,
0x0700,0x0740,0x0780,0x07a0,0x07c0,0x07c0,0x07e0,0x07e0,
0x07e0,0x07e0,0x07e0,0x07e0,0x07e0,0x17a2,0x76af,0xe71c,
0x0d5f,0x053e,0x051e,0x053e,0x051e,0x04bc,0xa619,0xef5d,
0xef7d,0xf79e,0xef9d,0xef5d,0xe71c,0xd6ba,0xce38,0xb5b6,
0x9cf3,0x43f3,0x0419,0x043a,0x0459,0x0439,0x0438,0x0417,
0x03f7,0x03b6,0x03b6,0x0395,0x0354,0x0333,0x0312,0x02f1,
0x02cf,0x2ace,0x3b0e,0x2aee,0x0a2c,0x020c,0x0189,0x4b2e,
0xf7bf,0xffff,0xffff,0xffff,0xffdf,0xef5d,0x736d,0x5aeb,
0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a69,0x4a49,0x4228,
0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,0x4a69,
0x528a,0x5acb,0x6b6d,0x8c51,0xa514,0xad55,0xad75,0xad75,
0xad96,0x942e,0x7ac1,0x8ae0,0x9b40,0xa360,0xb3a0,0xbbc0,
0xbc00,0xcc20,0xd460,0xdc60,0xe4a0,0xecc0,0xecc0,0xecc0,
0xece0,0xf500,0xf500,0xf500,0xfd20,0xfd20,0xfd40,0xfd40,
0xfd40,0xfd20,0xed46,0xe6da,0xe73d,0xef5c,0xef7d,0xef7d,
0xef5d,0xef3c,0xe73c,0xdefb,0xd698,0xe504,0xeca0,0xee0d,
0xfffe,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7fe,0x7daf,
0x0c42,0x0480,0x0500,0x0520,0x0520,0x0540,0x0560,0x0560,
0x0560,0x0560,0x0560,0x0560,0x0560,0x0560,0x0540,0x0560,
0x0560,0x0580,0x0580,0x05a0,0x05e0,0x0600,0x0640,0x06a0,
0x06c0,0x0700,0x0740,0x0780,0x07a0,0x07a0,0x07c0,0x07e0,
0x07e0,0x07e0,0x07e0,0x07e0,0x07e0,0x07e0,0x0f21,0xc7b8,
0x0d5e,0x053f,0x051e,0x051e,0x051e,0x04bc,0x7d79,0xdeba,
0xdedb,0xdefb,0xdefb,0xdedb,0xd69a,0xce39,0xbdd7,0xad55,
0x9cb1,0x33d4,0x0439,0x0479,0x045a,0x0459,0x0439,0x0419,
0x0417,0x03f7,0x03d6,0x03b6,0x0395,0x0374,0x0332,0x02f2,
0x2b30,0xa4f4,0xad74,0xa514,0x73f0,0x126d,0x01cb,0x09ca,
0xc69a,0xffff,0xef7e,0xef7d,0xf7be,0xd69a,0x5acb,0x5b0b,
0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a69,0x4a49,0x4a49,
0x4228,0x4228,0x4228,0x4228,0x4228,0x4228,0x4a49,0x4a49,
0x528a,0x5acb,0x8430,0x9cd3,0xa534,0xad75,0xb5b6,0xb5b6,
0x9c4c,0x82e1,0x9b00,0xa340,0xa380,0xb3c0,0xbbe0,0xc400,
0xcc20,0xd440,0xd480,0xe4a0,0xe4c0,0xe4c0,0xecc0,0xece0,
0xece0,0xf500,0xf500,0xf500,0xf520,0xf520,0xfd20,0xfd20,
0xfd40,0xfd20,0xf4e0,0xe58c,0xd6ba,0xdedb,0xdedb,0xdedb,
0xdedb,0xdeba,0xd6ba,0xce7a,0xc5f5,0xe4e3,0xf4c0,0xeca0,
0xedcb,0xffbb,0xffff,0xffff,0xffff,0xf7dd,0x54eb,0x03a0,
0x0420,0x04a0,0x04e0,0x04e0,0x0500,0x0520,0x0520,0x0540,
0x0560,0x0540,0x0560,0x0560,0x0580,0x0580,0x0560,0x0580,
0x0580,0x0580,0x05a0,0x05a0,0x05c0,0x0600,0x0620,0x0660,
0x06a0,0x06c0,0x0720,0x0740,0x0760,0x0780,0x07a0,0x07c0,
0x07c0,0x07e0,0x07e0,0x07e0,0x07e0,0x07a0,0x0760,0x7f4f,
0x0d7f,0x053f,0x053e,0x053e,0x051e,0x04fd,0x2cba,0xb5b6,
0xce37,0xce38,0xce38,0xc618,0xc5f7,0xb5b6,0xad55,0xa4d2,
0x6c31,0x0c18,0x047a,0x047a,0x045a,0x0479,0x0459,0x0439,
0x0418,0x03f8,0x03d7,0x03d6,0x03b6,0x0395,0x0354,0x0312,
0x1b51,0xbdd7,0xce58,0xbdd7,0xad34,0x636f,0x020b,0x0169,
0x5370,0xffbf,0xef7d,0xef5d,0xf7be,0xbdf7,0x52aa,0x5aeb,
0x5aeb,0x5acb,0x52aa,0x528a,0x4a69,0x4a69,0x4a69,0x4a49,
0x4229,0x4228,0x4228,0x4228,0x4228,0x4228,0x4249,0x4a6a,
0x5269,0x630b,0x8c71,0x9cf4,0xad55,0xb597,0xb553,0x93e9,
0x8ae0,0x9b20,0xa360,0xab80,0xb3a0,0xbbe0,0xc400,0xc420,
0xcc40,0xd460,0xdc80,0xe4a0,0xe4c0,0xe4c0,0xecc0,0xece0,
0xece0,0xf500,0xf500,0xf500,0xf500,0xfd20,0xfd20,0xfd20,
0xf520,0xfd20,0xf520,0xf4e0,0xd56d,0xc659,0xc65a,0xce59,
0xc659,0xc639,0xc5f8,0xb5d9,0xbd2f,0xe4c1,0xf4e0,0xece0,
0xecc0,0xe546,0xf715,0xffff,0xefbe,0x54aa,0x0320,0x03e0,
0x0420,0x0460,0x04a0,0x04e0,0x0500,0x0500,0x0520,0x0540,
0x0540,0x0560,0x0560,0x0540,0x0520,0x0d21,0x0d41,0x0561,
0x0560,0x0580,0x05c0,0x05c0,0x05e0,0x0600,0x0620,0x0660,
0x0680,0x06c0,0x06e0,0x0700,0x0740,0x0740,0x0760,0x0760,
0x07a0,0x07a0,0x07a0,0x07a0,0x0780,0x0760,0x0740,0x36c6,
0x0d5f,0x053f,0x053f,0x051f,0x051e,0x051e,0x04dc,0x3cb8,
0x9d35,0xb554,0xb575,0xb575,0xad34,0xa4f3,0x9492,0x5c33,
0x1437,0x045a,0x047b,0x047a,0x047a,0x045a,0x0459,0x0459,
0x0438,0x0418,0x0418,0x03f7,0x03d6,0x03b6,0x0395,0x0353,
0x02f2,0x5c33,0xbdf7,0xb5b6,0xa4f3,0x73ae,0x022b,0x01eb,
0x11a9,0xd6bb,0xf79e,0xef5d,0xf79e,0x9cf3,0x5aaa,0x630c,
0x5aeb,0x5acb,0x52aa,0x52aa,0x528a,0x4a69,0x4a49,0x4a49,
0x4a49,0x4a29,0x4228,0x4228,0x4228,0x4a49,0x4aaa,0x5247,
0x51e3,0x62c9,0x8c72,0x9cd3,0xa4d1,0x9c2b,0x8b24,0x92e0,
0xa340,0xa380,0xaba0,0xb3c0,0xbbe0,0xc400,0xcc20,0xcc40,
0xd460,0xdc80,0xdca0,0xe4a0,0xe4c0,0xe4c0,0xecc0,0xece0,
0xece0,0xece0,0xf500,0xf500,0xf500,0xf500,0xf520,0xf520,
0xf520,0xfd00,0xf520,0xf500,0xecc0,0xd529,0xc591,0xb5b6,
0xb597,0xad97,0xa555,0xacf1,0xd4a5,0xecc0,0xed00,0xf500,
0xf4e0,0xf4c0,0xece1,0xfe50,0x74eb,0x0280,0x0340,0x03c0,
0x0400,0x0460,0x0480,0x04c0,0x04e0,0x0500,0x0520,0x0520,
0x0520,0x0540,0x14e2,0x4d08,0x7daf,0x9e33,0xae75,0x9e53,
0x6ded,0x1dc3,0x0580,0x05e0,0x0600,0x0600,0x0620,0x0640,
0x0680,0x06a0,0x06c0,0x06e0,0x0700,0x0700,0x0720,0x0740,
0x0740,0x0760,0x0760,0x0760,0x0740,0x0720,0x0740,0x0701,
0x0d7f,0x053f,0x053f,0x053f,0x053f,0x053f,0x051e,0x04dd,
0x1c99,0x5496,0x6c94,0x7c73,0x6c73,0x4c55,0x2c36,0x045a,
0x049b,0x049b,0x049b,0x049b,0x049a,0x047a,0x0479,0x0479,
0x0459,0x0418,0x0418,0x0418,0x03f7,0x03d6,0x03b6,0x0395,
0x0353,0x02d2,0x43d2,0x8472,0x840f,0x42cc,0x020c,0x020c,
0x0148,0x8cd4,0xf7be,0xe73c,0xef7d,0x8430,0x5acb,0x630c,
0x5aeb,0x5acb,0x52aa,0x528a,0x528a,0x4a69,0x4a69,0x4a69,
0x4a49,0x4a48,0x4a48,0x4228,0x4a8a,0x630c,0x6286,0x6221,
0x6a20,0x72a3,0x8367,0x8b66,0x9302,0x92e0,0x9b20,0xa360,
0xaba0,0xb3c0,0xbbe0,0xc400,0xc400,0xcc20,0xcc40,0xd440,
0xd480,0xdca0,0xdca0,0xe4a0,0xe4c0,0xecc0,0xecc0,0xece0,
0xece0,0xece0,0xf500,0xf500,0xf500,0xf500,0xf500,0xf520,
0xf520,0xfd00,0xf500,0xf500,0xf500,0xecc0,0xe4c2,0xd4c7,
0xc4c9,0xbcc9,0xc4c7,0xd4a2,0xecc0,0xece0,0xece0,0xf500,
0xf500,0xf500,0xf4e0,0xf4c0,0xbc60,0x5361,0x0300,0x0380,
0x03e0,0x0440,0x0480,0x04a0,0x04e0,0x04e0,0x0500,0x0500,
0x0500,0x2484,0x748e,0xad76,0xd61a,0xde9c,0xeefd,0xf75e,
0xff5f,0xcf19,0x562a,0x05c0,0x0620,0x0640,0x0640,0x0660,
0x0680,0x0680,0x06a0,0x06c0,0x06c0,0x06e0,0x0700,0x0700,
0x0720,0x0740,0x0720,0x0720,0x0720,0x0700,0x0700,0x0720,
0x155f,0x053f,0x055f,0x053f,0x055f,0x053f,0x053e,0x053e,
0x04fe,0x04dc,0x0cbb,0x0c9a,0x0c9a,0x049b,0x04bc,0x04bc,
0x04bc,0x04bc,0x04bb,0x049b,0x049b,0x049a,0x047a,0x045a,
0x045a,0x0439,0x0439,0x0418,0x03f8,0x03f7,0x03f7,0x03b6,
0x0395,0x0354,0x02f1,0x12d0,0x22ae,0x0a4d,0x024d,0x022c,
0x0169,0x536f,0xef7d,0xe71c,0xe71c,0x73ae,0x5acb,0x62ec,
0x5aeb,0x5acb,0x52aa,0x528a,0x528a,0x4a69,0x4a69,0x4a69,
0x4a49,0x4a49,0x4a48,0x4a6a,0x630b,0x6aa5,0x7240,0x7a60,
0x7aa0,0x82a0,0x8ac0,0x92e0,0x9b20,0xa360,0xab80,0xb3a0,
0xb3c0,0xbbe0,0xc400,0xcc20,0xcc20,0xcc40,0xd440,0xd460,
0xdc80,0xdca0,0xe4a0,0xe4a0,0xecc0,0xece0,0xecc0,0xece0,
0xece0,0xece0,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf520,0xf500,0xfd00,0xf500,0xf500,0xf500,0xece0,0xecc0,
0xecc0,0xecc0,0xecc0,0xf4c0,0xece0,0xece0,0xf4e0,0xf500,
0xf500,0xf500,0xf500,0xf500,0xfd20,0xf501,0x9c42,0x2340,
0x0360,0x0400,0x0460,0x0480,0x04c0,0x04e0,0x04e0,0x04e0,
0x1422,0x638c,0x9452,0xa514,0xb5b6,0xce58,0xdedb,0xe75d,
0xf79e,0xff9f,0xef7d,0x564a,0x0620,0x0640,0x0660,0x0680,
0x0680,0x06a0,0x06a0,0x06c0,0x06c0,0x06c0,0x06e0,0x06e0,
0x0700,0x0700,0x0720,0x0700,0x0700,0x0720,0x0720,0x0720,
0x157f,0x053f,0x053f,0x053f,0x053f,0x055f,0x053f,0x053e,
0x053e,0x051e,0x051e,0x04fe,0x04fd,0x04fd,0x04fd,0x04fd,
0x04dd,0x04dd,0x04dc,0x04bc,0x049b,0x049a,0x047a,0x047a,
0x045a,0x0459,0x0438,0x0418,0x0418,0x03f7,0x03f7,0x03d6,
0x0395,0x0354,0x0332,0x02f1,0x02d0,0x028f,0x026e,0x022d,
0x018a,0x326c,0xdf1c,0xe73c,0xd69a,0x6b4d,0x5aeb,0x5aeb,
0x5aeb,0x52aa,0x52aa,0x528a,0x528a,0x4a69,0x4a69,0x4a69,
0x4a49,0x4a48,0x4249,0x5289,0x6a84,0x7240,0x8280,0x82c0,
0x8ae0,0x9320,0x9320,0x9b60,0xa380,0xaba0,0xb3c0,0xbbe0,
0xc400,0xc420,0xcc20,0xcc40,0xd440,0xd460,0xd460,0xdc80,
0xdca0,0xe4a0,0xe4c0,0xe4c0,0xecc0,0xecc0,0xece0,0xece0,
0xece0,0xece0,0xf500,0xf500,0xf500,0xf500,0xf520,0xf520,
0xf500,0xf520,0xfd00,0xf500,0xf520,0xf500,0xf500,0xf500,
0xed00,0xed00,0xed00,0xece0,0xed00,0xf500,0xf520,0xf500,
0xf500,0xf500,0xf520,0xf500,0xf500,0xfd00,0xfd00,0xcca1,
0x4380,0x0380,0x0420,0x0480,0x04a0,0x04c0,0x04c0,0x04a0,
0x3326,0x732e,0x7c0f,0x94b2,0xad76,0xc638,0xd6ba,0xe71c,
0xef7d,0xf79e,0xff9f,0xcf59,0x1e23,0x0660,0x0680,0x0680,
0x06a0,0x06a0,0x06a0,0x06c0,0x06c0,0x06e0,0x06e0,0x06e0,
0x06e0,0x06e0,0x0700,0x0700,0x0700,0x0700,0x0720,0x0740,
0x0d7f,0x053f,0x053f,0x053f,0x055f,0x053f,0x053f,0x053f,
0x053e,0x051e,0x051e,0x051e,0x04fd,0x04fd,0x04fd,0x04fd,
0x04dd,0x04dd,0x04dc,0x04dc,0x049b,0x049b,0x049a,0x047a,
0x047a,0x0459,0x0459,0x0438,0x0418,0x0418,0x03f7,0x03d6,
0x03b5,0x0374,0x0333,0x02f1,0x02d1,0x02af,0x026e,0x022d,
0x01ab,0x19ea,0xce99,0xe71c,0xc638,0x630c,0x630c,0x5aeb,
0x5aeb,0x5acb,0x52aa,0x528a,0x528a,0x528a,0x4a69,0x4a69,
0x4a69,0x4a49,0x4a48,0x6243,0x7a60,0x82a0,0x8ac0,0x8b00,
0x9320,0x9b40,0xa360,0xaba0,0xb3a0,0xb3c0,0xbbe0,0xc400,
0xcc20,0xcc40,0xcc40,0xd460,0xd460,0xd480,0xdc80,0xdc80,
0xe4a0,0xe4a0,0xecc0,0xece0,0xecc0,0xece0,0xece0,0xece0,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf520,0xf520,
0xf500,0xfd00,0xf520,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf4e0,0xf500,0xf4e0,0xf500,0xf4e0,0xf500,0xf500,0xf500,
0xf500,0xf520,0xf520,0xfd00,0xf500,0xf500,0xf500,0xfd00,
0xe4e1,0x53c1,0x03c0,0x0440,0x0480,0x04a0,0x04a0,0x0461,
0x32a6,0x62cc,0x73ae,0x8c50,0xa513,0xbdd7,0xce79,0xdedb,
0xe71c,0xef5e,0xef7e,0xef5e,0x4e69,0x0680,0x0680,0x06a0,
0x06a0,0x06c0,0x06c0,0x06c0,0x06e0,0x06e0,0x06e0,0x06e0,
0x0700,0x0700,0x0700,0x0700,0x0720,0x0720,0x0760,0x0760,
0x0d7f,0x055f,0x053f,0x053f,0x053f,0x055f,0x055f,0x053f,
0x053e,0x053e,0x051e,0x051e,0x051d,0x051e,0x04fe,0x04fe,
0x051e,0x04fd,0x04fd,0x04bc,0x04bb,0x049b,0x049b,0x047a,
0x047a,0x045a,0x045a,0x0419,0x0418,0x03f8,0x03f7,0x03d6,
0x03b5,0x0354,0x0333,0x0312,0x02d0,0x028f,0x026e,0x022c,
0x01aa,0x11c9,0xc658,0xe71c,0xb5b6,0x5aeb,0x630c,0x5b0b,
0x5aeb,0x5acb,0x5acb,0x52aa,0x528a,0x528a,0x528a,0x4a69,
0x4a69,0x4a49,0x5a43,0x7260,0x82a0,0x8ae0,0x9300,0x9b20,
0xa360,0xab80,0xb3c0,0xb3c0,0xbbc0,0xc400,0xc420,0xcc20,
0xcc40,0xd440,0xd460,0xd460,0xd480,0xdc80,0xdca0,0xe4a0,
0xe4c0,0xecc0,0xecc0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xf500,0xf500,0xf500,0xf520,0xfd20,0xfd20,0xf520,0xf520,
0xf520,0xf520,0xfd20,0xf520,0xf500,0xf520,0xfd00,0xf500,
0xf500,0xf500,0xf500,0xf500,0xfd00,0xf500,0xf500,0xf500,
0xf520,0xf500,0xf520,0xf500,0xfd00,0xf520,0xf500,0xf500,
0xfd00,0xe500,0x4be0,0x03e0,0x0460,0x0480,0x0480,0x0480,
0x22a5,0x524a,0x6b4c,0x7bef,0x94b2,0xad55,0xbdf7,0xce59,
0xd6ba,0xdedb,0xe6fc,0xdefb,0x3e67,0x06a0,0x06a0,0x06c0,
0x06c0,0x06c0,0x06e0,0x0700,0x0700,0x0700,0x0700,0x0700,
0x0700,0x0700,0x0700,0x0720,0x0720,0x0700,0x0720,0x0740,
0x155f,0x055f,0x053f,0x055f,0x055f,0x055f,0x053f,0x053f,
0x053f,0x053e,0x051e,0x051e,0x051e,0x051e,0x051e,0x051e,
0x051d,0x04fe,0x04fc,0x04dc,0x04dc,0x049c,0x049a,0x047a,
0x045a,0x043a,0x0418,0x0c18,0x1438,0x0bf7,0x03d6,0x03d6,
0x0395,0x0354,0x0332,0x02f2,0x02b0,0x028f,0x024e,0x022c,
0x01ca,0x0968,0xb5b6,0xdefb,0xad75,0x5aeb,0x630c,0x630c,
0x5aeb,0x5acb,0x52aa,0x52aa,0x528a,0x528a,0x4a69,0x4a69,
0x4a6a,0x5244,0x7260,0x82a0,0x8ae0,0x9320,0x9b40,0xa380,
0xaba0,0xb3c0,0xb3e0,0xbbe0,0xc400,0xcc20,0xcc40,0xcc40,
0xcc40,0xd460,0xd460,0xdc80,0xdc80,0xdca0,0xe4a0,0xe4a0,
0xe480,0xe480,0xe4a0,0xecc0,0xece0,0xece0,0xed00,0xf500,
0xf500,0xf500,0xf520,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xf520,0xfd00,0xfd20,0xf520,
0xf500,0xf500,0xf520,0xf500,0xf500,0xf500,0xfd20,0xfd20,
0xf520,0xfd20,0xfd20,0xf520,0xfd20,0xf520,0xf520,0xf500,
0xf500,0xfce0,0xdcc1,0x33c0,0x03e0,0x0460,0x0480,0x04a0,
0x0bc1,0x3a47,0x62ab,0x738e,0x8430,0x9cd3,0xad55,0xb5b7,
0xc5f8,0xce39,0xde5b,0x8650,0x0e61,0x06c0,0x06c0,0x06c0,
0x06e0,0x06e0,0x0700,0x0700,0x0700,0x0700,0x0720,0x0700,
0x0700,0x0720,0x0720,0x0720,0x0f01,0x5f0b,0x7f2f,0x5f2b,
0x0d5f,0x053f,0x053f,0x053f,0x053f,0x053f,0x053f,0x053f,
0x053e,0x053e,0x053e,0x051e,0x051e,0x051e,0x051e,0x051e,
0x04fe,0x04fd,0x04fd,0x04dc,0x04bc,0x04bb,0x049b,0x047a,
0x045a,0x0c39,0x6559,0xa5f9,0xa5d7,0x8d15,0x4c34,0x0374,
0x0375,0x0353,0x0312,0x02f1,0x02d0,0x028e,0x024d,0x020c,
0x01aa,0x0168,0xa534,0xdebb,0x9cf3,0x5aeb,0x630c,0x630c,
0x5aeb,0x5acb,0x5aab,0x52aa,0x528a,0x528a,0x5289,0x4a8a,
0x5248,0x6a61,0x82c0,0x8ae0,0x9b20,0xa340,0xab80,0xaba0,
0xb3c0,0xbbe0,0xc400,0xc400,0xcc20,0xcc40,0xcc40,0xcc40,
0xd460,0xd480,0xd480,0xdc80,0xdca0,0xe480,0xdc80,0xd4a4,
0xcd09,0xcd6c,0xd56d,0xdd49,0xe504,0xecc0,0xf4e0,0xf500,
0xf500,0xf520,0xfd20,0xfd20,0xfd40,0xfd20,0xfd20,0xfd20,
0xfd40,0xfd40,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd00,0xfd20,0xf520,0xfd20,0xfd00,0xfd20,0xfd20,
0xf520,0xfd20,0xfd20,0xfd20,0xf520,0xf520,0xfd20,0xfd20,
0xf520,0xf500,0xfd00,0xbc81,0x1ba0,0x0420,0x0460,0x04a0,
0x04c0,0x13c2,0x42c7,0x630c,0x7baf,0x8c31,0x9cb3,0xa515,
0xb576,0xadb5,0x75ce,0x0e42,0x06a0,0x06a0,0x06c0,0x06c0,
0x06e0,0x06e0,0x0700,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0720,0x0720,0x0740,0x26e3,0xaf35,0xf79e,0xffdf,0xf7de,
0x0d5f,0x053f,0x053f,0x053f,0x053e,0x053f,0x053e,0x053e,
0x053e,0x051e,0x051e,0x051e,0x051e,0x051e,0x051e,0x051e,
0x04fe,0x04fd,0x04fd,0x04dc,0x04bc,0x049b,0x047a,0x045a,
0x0439,0x85da,0xef5c,0xef1b,0xdeba,0xce38,0xb575,0x53d1,
0x0332,0x0332,0x0312,0x02f1,0x02af,0x026e,0x024d,0x01eb,
0x0189,0x1167,0x94b2,0xd69a,0x9491,0x5b0b,0x630c,0x5b0b,
0x5aeb,0x5acb,0x52cb,0x52aa,0x52aa,0x528a,0x5289,0x4a6a,
0x5a43,0x7a80,0x8ae0,0x9b20,0xa360,0xaba0,0xb3c0,0xbbe0,
0xbbe0,0xc400,0xc420,0xcc20,0xcc40,0xcc40,0xd460,0xd460,
0xd460,0xdc60,0xdc80,0xdc80,0xdc80,0xcc83,0xc54e,0xce38,
0xd69b,0xdefc,0xe6fc,0xdefb,0xdeda,0xddf0,0xed03,0xf4e0,
0xf520,0xf520,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,0xfd20,0xfd20,
0xf520,0xfd20,0xfd20,0xfd20,0xf520,0xf520,0xfd20,0xf520,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xf520,0xfd20,0xfd20,
0xf520,0xf520,0xed00,0xfce0,0x8421,0x03c0,0x0460,0x04a0,
0x04e0,0x0520,0x04e0,0x2424,0x4bc9,0x5c2c,0x6c6d,0x6ccd,
0x5d2b,0x25c4,0x0641,0x06a0,0x06a0,0x06c0,0x06c0,0x06e0,
0x0700,0x0700,0x0700,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0720,0x0720,0x0720,0x8ed1,0xf71e,0xf79e,0xffff,0xffff,
0x155e,0x051e,0x053e,0x051e,0x051e,0x051e,0x051e,0x051e,
0x051e,0x051e,0x051e,0x051e,0x051e,0x051e,0x051d,0x04fd,
0x04fd,0x04dd,0x04dc,0x04bc,0x049b,0x049b,0x047a,0x0439,
0x3cfa,0xef9e,0xf79d,0xe73c,0xd6ba,0xce59,0xb5b6,0x9491,
0x1b31,0x0312,0x02f1,0x02d0,0x028f,0x026e,0x022c,0x01eb,
0x0168,0x2187,0x8c51,0xc638,0x8430,0x630c,0x630c,0x630c,
0x5aeb,0x5acb,0x5acb,0x52ca,0x52aa,0x528a,0x528a,0x5248,
0x6a60,0x8ac0,0x9b20,0xa360,0xaba0,0xb3c0,0xbbe0,0xc400,
0xc400,0xcc20,0xcc20,0xcc40,0xd440,0xd460,0xd460,0xd460,
0xd480,0xdc80,0xdc80,0xdc60,0xcc85,0xbdb4,0xd6bb,0xe71c,
0xef5d,0xf79e,0xf7be,0xf7be,0xf7bf,0xef9f,0xeed7,0xed24,
0xf500,0xfd20,0xfd40,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xf520,0xfd20,
0xf520,0xfd00,0xf500,0xf500,0xe4c0,0x43c0,0x03e0,0x04a0,
0x04e0,0x0520,0x0580,0x05a0,0x05a0,0x0580,0x05a0,0x0600,
0x0620,0x0660,0x0680,0x06a0,0x06a0,0x06c0,0x06c0,0x0700,
0x0700,0x0700,0x0700,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0740,0x0740,0x1ec3,0xb696,0xe6dd,0xef5c,0xf79e,0xf7bf,
0x153e,0x051e,0x051d,0x04fe,0x051d,0x051e,0x051e,0x051e,
0x04fe,0x04fe,0x04fe,0x04fe,0x051d,0x04fd,0x04fd,0x04fd,
0x04dc,0x04bc,0x04bb,0x049b,0x047a,0x047a,0x045a,0x0419,
0x7d9a,0xf79e,0xe75c,0xdefb,0xd699,0xc618,0xad76,0x9492,
0x3b4f,0x02d1,0x02f1,0x02d0,0x028f,0x024d,0x020c,0x01aa,
0x0148,0x31c8,0x7bef,0xbdd7,0x7bf0,0x630c,0x632c,0x630c,
0x5aeb,0x5acb,0x5acb,0x52ca,0x52aa,0x528a,0x528a,0x5a43,
0x8280,0x9300,0x9b40,0xaba0,0xb3c0,0xbbe0,0xc400,0xc400,
0xcc20,0xcc20,0xcc20,0xcc40,0xd460,0xd460,0xd460,0xdc80,
0xdc80,0xdc80,0xdc80,0xd461,0xb551,0xce9a,0xdefc,0xef5d,
0xf79d,0xffbe,0xffdf,0xffff,0xffff,0xffff,0xf7ff,0xee73,
0xece1,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd40,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xf520,0xf520,0xf500,0xfce0,0xb461,0x0b80,0x0440,
0x04c0,0x0520,0x0560,0x05a0,0x05c0,0x05e0,0x0620,0x0620,
0x0660,0x0660,0x0680,0x0680,0x06c0,0x06c0,0x06e0,0x06e0,
0x0700,0x0700,0x0700,0x0720,0x0720,0x0720,0x0720,0x0740,
0x0740,0x0760,0x16c2,0xa614,0xd63a,0xd6da,0xe6fb,0xe71b,
0x0d1d,0x04fd,0x04fd,0x04fd,0x04fd,0x04fd,0x04fd,0x04fd,
0x04fd,0x04fd,0x04fd,0x04fd,0x04fd,0x04dd,0x04dc,0x04dc,
0x04bc,0x049b,0x049b,0x047a,0x045a,0x047a,0x0459,0x03f8,
0x7578,0xdefb,0xd6ba,0xce99,0xc618,0xb5b6,0xa534,0x8c50,
0x3b0e,0x02d1,0x02d0,0x02af,0x026e,0x022c,0x01eb,0x0189,
0x0947,0x4228,0x6b6d,0xad55,0x73af,0x632c,0x632c,0x630c,
0x5aec,0x5aeb,0x5acb,0x52aa,0x52aa,0x52aa,0x5268,0x6a40,
0x8ae0,0x9b20,0xa380,0xb3c0,0xbbe0,0xc400,0xc420,0xcc20,
0xcc20,0xcc40,0xcc40,0xd440,0xd460,0xd460,0xd480,0xdc80,
0xdc80,0xe4a0,0xe480,0xc487,0xbdd7,0xd69a,0xe6fc,0xef5d,
0xf79e,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xf73b,
0xed03,0xfd00,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd40,0xfd40,0xfd20,
0xfd40,0xfd20,0xfd40,0xfd20,0xfd20,0xfd20,0xfd20,0xf540,
0xfd20,0xf520,0xfd00,0xf500,0xece0,0xecc0,0x53a0,0x03e0,
0x0480,0x0520,0x0560,0x05a0,0x05c0,0x05e0,0x0600,0x0620,
0x0640,0x0660,0x0680,0x06a0,0x06c0,0x06c0,0x06e0,0x0700,
0x0700,0x0700,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0740,0x0740,0x0720,0x65ec,0xbd77,0xc5d8,0xc638,0xc639,
0x151d,0x04dd,0x04dc,0x04dc,0x04dc,0x04dc,0x04dc,0x04dd,
0x04dd,0x04dd,0x04dd,0x04dc,0x04dc,0x04dc,0x04bc,0x04bb,
0x049b,0x047b,0x047a,0x047a,0x0459,0x0459,0x0439,0x03f8,
0x4477,0xc618,0xc618,0xbdf7,0xb596,0xa514,0x9472,0x7b8e,
0x1ace,0x02d1,0x02b0,0x028e,0x024d,0x020c,0x01aa,0x0148,
0x21a7,0x4a28,0x630c,0x94b2,0x738e,0x632c,0x632c,0x630c,
0x5b0c,0x5aeb,0x5acb,0x5aaa,0x5aaa,0x52ab,0x5a45,0x7a80,
0x8b00,0x9b40,0xaba0,0xbbe0,0xc400,0xcc00,0xcc20,0xcc20,
0xcc40,0xcc40,0xd440,0xd460,0xd460,0xd480,0xdc80,0xdc80,
0xdca0,0xdca0,0xdc80,0xb4cb,0xbdd7,0xce79,0xdedb,0xe73c,
0xef7d,0xf7be,0xffdf,0xffdf,0xffdf,0xffbf,0xf7be,0xef3a,
0xe503,0xfd00,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,
0xfd40,0xf520,0xfd20,0xfd20,0xf500,0xf4e0,0xed00,0xfd00,
0xfd20,0xfd40,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd00,0xfd20,0xf520,0xf500,0xed00,0xf4c0,0xa421,0x0b60,
0x0420,0x04c0,0x0540,0x0580,0x05a0,0x05c0,0x0600,0x0620,
0x0640,0x0660,0x0680,0x06a0,0x06c0,0x06e0,0x06e0,0x0700,
0x0700,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0720,0x0740,0x0740,0x0ec1,0x6d8d,0x9d14,0xa534,0xa534,
0x14fc,0x04bc,0x04bc,0x04bc,0x04bc,0x04bc,0x04bc,0x04bc,
0x04bc,0x04bc,0x04bc,0x04bc,0x04bc,0x04bb,0x049b,0x049b,
0x047a,0x047a,0x0459,0x0459,0x0439,0x0438,0x0418,0x03f7,
0x03d6,0x84f5,0xb555,0xa534,0x9cd3,0x9451,0x73ae,0x3acc,
0x02d0,0x02d0,0x028f,0x026e,0x022c,0x01eb,0x0189,0x1147,
0x39e7,0x4a28,0x5aeb,0x8430,0x738e,0x632c,0x632c,0x630c,
0x5b0c,0x5acb,0x5acb,0x5aca,0x5aaa,0x52aa,0x6242,0x82a0,
0x9320,0xa360,0xb3c0,0xbbe0,0xc400,0xcc00,0xcc20,0xcc40,
0xcc40,0xcc40,0xd460,0xd460,0xd460,0xdc80,0xdc80,0xdca0,
0xe4a0,0xe4a0,0xe480,0xbca9,0xb597,0xc638,0xd69a,0xdefc,
0xe73c,0xef5c,0xef7d,0xf79e,0xef9d,0xef7d,0xe77f,0xe653,
0xece1,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,
0xfd20,0xfd20,0xfd00,0xe504,0xe5ac,0xe631,0xee0e,0xed47,
0xece0,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xf520,0xfd20,0xf500,0xece0,0xeca0,0xd460,0x3340,
0x03e0,0x0480,0x04e0,0x0540,0x0580,0x05c0,0x0600,0x0620,
0x0640,0x0660,0x0680,0x06a0,0x06c0,0x06e0,0x06e0,0x0700,
0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0740,0x0740,0x0740,0x0740,0x06e0,0x2e05,0x4d69,0x3da7,
0x14dc,0x04bb,0x04bb,0x049b,0x049b,0x049b,0x049b,0x049b,
0x04bb,0x049b,0x049b,0x049b,0x049b,0x047a,0x047a,0x045a,
0x045a,0x0459,0x0459,0x0438,0x0418,0x0418,0x03f7,0x03f7,
0x03d6,0x1394,0x6c32,0x8430,0x73cf,0x5b4e,0x32cd,0x02d0,
0x02d1,0x02af,0x026e,0x022d,0x020c,0x01aa,0x0967,0x31a7,
0x39e7,0x4208,0x5acb,0x73ae,0x738e,0x6b4d,0x632c,0x630c,
0x630c,0x5aeb,0x5acb,0x5aca,0x52ab,0x528a,0x6a41,0x8ac0,
0x9b40,0xab80,0xb3c0,0xbbe0,0xc400,0xcc00,0xcc20,0xcc40,
0xcc40,0xd440,0xd460,0xd460,0xdc80,0xdc80,0xdc80,0xdca0,
0xe4a0,0xe4a0,0xe4a0,0xc484,0xad34,0xbdf8,0xce59,0xd67a,
0xd6ba,0xdedb,0xdefb,0xdf1c,0xdefb,0xdf1c,0xd6ba,0xe526,
0xf4e0,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,
0xfd20,0xfd00,0xe504,0xde76,0xef7f,0xffdf,0xffff,0xf7be,
0xee2e,0xece1,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd20,0xf500,0xf500,0xece0,0xe4c0,0xe480,0x6380,
0x0380,0x0420,0x04c0,0x0500,0x0540,0x0580,0x05c0,0x05e0,
0x0620,0x0640,0x0680,0x0680,0x06c0,0x06e0,0x0700,0x0700,
0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
0x0720,0x0720,0x0720,0x0740,0x0720,0x0720,0x0720,0x0720,
0x0cdc,0x049b,0x049b,0x047b,0x047a,0x049a,0x047b,0x047a,
0x047a,0x047a,0x047a,0x047a,0x047a,0x045a,0x045a,0x0439,
0x0439,0x0419,0x0419,0x0418,0x0417,0x03f7,0x03d7,0x03d6,
0x03b5,0x0395,0x0b53,0x1b31,0x22ef,0x0ad0,0x02f1,0x02d0,
0x02af,0x028e,0x024e,0x020c,0x01aa,0x1147,0x3186,0x39a7,
0x39a7,0x4228,0x52cb,0x632d,0x6b6d,0x6b4d,0x6b4d,0x632c,
0x630c,0x5aeb,0x5acb,0x5acb,0x52cb,0x5288,0x7261,0x8ae0,
0x9b40,0xaba0,0xb3a0,0xbbe0,0xc420,0xcc20,0xcc40,0xcc40,
0xd440,0xd460,0xd460,0xd460,0xdc80,0xdc80,0xdca0,0xe4c0,
0xe4c0,0xe4c0,0xe4c0,0xdc80,0xbcaa,0xa576,0xb5d7,0xc618,
0xc659,0xce79,0xce7a,0xce7b,0xce9b,0xce58,0xdd49,0xece0,
0xfd20,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,
0xfd00,0xece0,0xd58f,0xe73d,0xffdf,0xffff,0xffff,0xffff,
0xffff,0xedcb,0xf4e0,0xfd20,0xfd20,0xfd20,0xfd20,0xf520,
0xf520,0xf500,0xfd00,0xf500,0xece0,0xe4c0,0xe480,0x8bc1,
0x0320,0x03c0,0x0460,0x04c0,0x0500,0x0560,0x0580,0x05c0,
0x05e0,0x0620,0x0660,0x0680,0x06a0,0x06c0,0x06e0,0x0700,
0x0700,0x0700,0x0720,0x0720,0x0700,0x0720,0x0720,0x0720,
0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
0x1439,0x0419,0x045a,0x047a,0x0479,0x045a,0x047a,0x045a,
0x047a,0x045a,0x045a,0x0459,0x0459,0x0439,0x0439,0x0438,
0x0418,0x0418,0x03f7,0x03f7,0x03d7,0x03d6,0x03b6,0x0395,
0x0395,0x0374,0x0354,0x0333,0x0312,0x02f1,0x02d1,0x02b0,
0x028e,0x026d,0x020c,0x01aa,0x1946,0x21c4,0x1a24,0x2204,
0x39e7,0x4a28,0x4a69,0x5b0c,0x738e,0x6b6d,0x6b4c,0x632c,
0x630c,0x630b,0x5aeb,0x52eb,0x5aab,0x5a87,0x7260,0x8ae0,
0x9b40,0xaba0,0xb3c0,0xbbe0,0xc400,0xcc20,0xcc20,0xcc40,
0xcc40,0xd460,0xd460,0xdc80,0xdc80,0xdc80,0xe4a0,0xe4c0,
0xe4e0,0xecc0,0xe4c0,0xe4a0,0xdca0,0xbcc9,0xa513,0xad76,
0xb5b7,0xb5d7,0xbdf8,0xbdf7,0xc592,0xdce7,0xece0,0xfd00,
0xfd20,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,
0xf500,0xecc0,0xc590,0xd6fc,0xf77e,0xffde,0xffff,0xffdf,
0xf7bf,0xee74,0xecc1,0xfd20,0xfd20,0xf520,0xf520,0xfd20,
0xf520,0xf500,0xf500,0xed00,0xece0,0xe4c0,0xe480,0xa401,
0x12c0,0x0380,0x0400,0x0460,0x04c0,0x0500,0x0540,0x0580,
0x05c0,0x0600,0x0620,0x0660,0x0680,0x06c0,0x06c0,0x06e0,
0x0700,0x06e0,0x0700,0x0700,0x0700,0x0700,0x0700,0x0700,
0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
0x8e1b,0x657b,0x1c79,0x0419,0x0459,0x0459,0x0439,0x0459,
0x0439,0x0439,0x0439,0x0439,0x0438,0x0418,0x0418,0x0417,
0x03f7,0x03f7,0x03d6,0x03b6,0x03b6,0x03b5,0x0395,0x0374,
0x0353,0x0353,0x0332,0x0312,0x02f1,0x02d1,0x028f,0x028f,
0x022d,0x01eb,0x11a8,0x2966,0x19a3,0x0a21,0x1202,0x1a63,
0x1a63,0x3a47,0x528a,0x6b2d,0x6b8e,0x6b6d,0x6b4d,0x632c,
0x630c,0x5aeb,0x5aeb,0x5acb,0x52cb,0x5a66,0x7280,0x92e0,
0xa340,0xaba0,0xb3c0,0xbbe0,0xc400,0xc420,0xcc40,0xcc40,
0xd460,0xd460,0xd480,0xdc80,0xdca0,0xe4a0,0xe4c0,0xecc0,
0xecc0,0xece0,0xece0,0xece0,0xecc0,0xe4a0,0xd4a3,0xccc8,
0xbced,0xbd0d,0xc50b,0xd4e6,0xece2,0xf4e0,0xfd20,0xf520,
0xfd20,0xfd20,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,
0xf500,0xece0,0xc4ec,0xc659,0xdedc,0xe71c,0xe73c,0xe71c,
0xdefc,0xcdf2,0xe4c1,0xf500,0xfd20,0xfd20,0xf520,0xfd00,
0xf500,0xf500,0xf500,0xed00,0xece0,0xe4c0,0xe480,0xbc01,
0x1aa0,0x0320,0x03a0,0x0400,0x0460,0x04c0,0x0500,0x0540,
0x0580,0x05c0,0x05e0,0x0620,0x0640,0x0680,0x06a0,0x06c0,
0x06e0,0x06e0,0x06e0,0x0700,0x0700,0x0700,0x0700,0x0700,
0x0700,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0700,
0xffff,0xf7be,0xcebc,0x44b7,0x03f8,0x0418,0x0418,0x0418,
0x0418,0x0418,0x0418,0x0418,0x03f8,0x03f7,0x03f7,0x03d7,
0x03d6,0x03b6,0x0395,0x0395,0x0395,0x0374,0x0353,0x0353,
0x0352,0x02f2,0x02f1,0x02f1,0x02b0,0x028f,0x024e,0x01eb,
0x0208,0x0162,0x2965,0x39c6,0x0200,0x0180,0x31c6,0x4208,
0x4268,0x2a85,0x42c8,0x6b6d,0x738e,0x6b6d,0x6b4c,0x632c,
0x630c,0x62ec,0x5aeb,0x5acb,0x52cb,0x5a66,0x7280,0x9300,
0x9b40,0xab80,0xb3a0,0xbbe0,0xc400,0xcc20,0xcc40,0xd440,
0xd460,0xd460,0xdc80,0xdc80,0xdca0,0xe4c0,0xe4e0,0xece0,
0xecc0,0xece0,0xecc0,0xecc0,0xece0,0xece0,0xecc0,0xece0,
0xecc0,0xecc0,0xece0,0xf500,0xf500,0xf500,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,
0xfd20,0xf500,0xd4a3,0xb531,0xbdf8,0xc639,0xce39,0xc639,
0xb5d9,0xc4ea,0xece0,0xfd00,0xfd20,0xfd20,0xf520,0xf500,
0xf500,0xf500,0xed00,0xece0,0xecc0,0xe4a0,0xe480,0xbc21,
0x22a0,0x02e0,0x0360,0x03c0,0x0420,0x0480,0x04c0,0x0500,
0x0540,0x0580,0x05a0,0x05e0,0x0600,0x0640,0x0680,0x0680,
0x06a0,0x06c0,0x06c0,0x06c0,0x06e0,0x06e0,0x0700,0x0700,
0x0700,0x0700,0x0700,0x06e0,0x0700,0x06e0,0x06e0,0x06e0,
0xef7d,0xe73c,0xdeba,0xadb6,0x1bd5,0x03d7,0x03f7,0x03d7,
0x03f7,0x03f7,0x03d6,0x03d6,0x03d6,0x03b6,0x03b6,0x03b6,
0x0395,0x0395,0x0375,0x0374,0x0353,0x0333,0x0333,0x0332,
0x0312,0x02d1,0x02b0,0x026e,0x022d,0x122c,0x222b,0x3209,
0x1a83,0x09c0,0x1943,0x3185,0x09e1,0x1982,0x39c7,0x4a28,
0x4a69,0x52aa,0x4288,0x632c,0x738e,0x6b6c,0x6b4d,0x632d,
0x632c,0x62eb,0x5aeb,0x5acb,0x5acb,0x5a67,0x7a80,0x9300,
0x9b40,0xab80,0xb3a0,0xb3c0,0xbbc0,0xbbe0,0xcc00,0xd420,
0xd460,0xd480,0xdc80,0xdca0,0xe4a0,0xe4a0,0xecc0,0xece0,
0xecc0,0xecc0,0xece0,0xece0,0xece0,0xece0,0xece0,0xf4e0,
0xece0,0xf500,0xf500,0xf520,0xf520,0xfd20,0xf520,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd40,0xfd20,0xfd20,0xfd40,
0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,
0xf520,0xf500,0xece0,0xcc84,0xacef,0xa514,0xa535,0x9cf3,
0xac8c,0xd4a2,0xf4e0,0xf500,0xfd20,0xfd00,0xf500,0xf500,
0xf500,0xed00,0xed00,0xece0,0xecc0,0xe4a0,0xdc80,0xc420,
0x2a80,0x02a0,0x0320,0x0380,0x03e0,0x0420,0x0480,0x04c0,
0x0500,0x0540,0x0580,0x05a0,0x05e0,0x0600,0x0640,0x0660,
0x0680,0x0680,0x06a0,0x06a0,0x06c0,0x06e0,0x06c0,0x06c0,
0x06c0,0x06e0,0x06e0,0x06e0,0x06c0,0x06c0,0x06c0,0x06a0,
0xce59,0xc638,0xbdd7,0xad13,0x23b3,0x0395,0x03b6,0x03d6,
0x03b6,0x03b6,0x0395,0x0395,0x0395,0x0395,0x0395,0x0374,
0x0374,0x0354,0x0353,0x0332,0x0332,0x0312,0x02f2,0x02d0,
0x028f,0x026f,0x126d,0x32ad,0x4b2e,0x6b8e,0x630b,0x630b,
0x530a,0x3a68,0x3a07,0x39e8,0x4248,0x4a89,0x4a6a,0x4a69,
0x5269,0x4a89,0x528a,0x5b0c,0x73ae,0x6b6d,0x6b4d,0x632d,
0x630c,0x630b,0x5aec,0x5acb,0x52aa,0x5aa8,0x7a80,0x92e0,
0x9b40,0xab60,0xab80,0xab80,0xac28,0xaccd,0xb4ec,0xc444,
0xd440,0xdc60,0xdc80,0xe480,0xe4a0,0xe4c0,0xecc0,0xecc0,
0xecc0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xf4e0,
0xf4e0,0xf500,0xf500,0xfd20,0xfd00,0xfd20,0xf520,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xfd20,0xfd40,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
0xfd20,0xf500,0xf500,0xece0,0xdca1,0xc466,0xb467,0xbc65,
0xdca0,0xf4e0,0xf500,0xf520,0xf500,0xf520,0xf500,0xf500,
0xf4e0,0xed00,0xece0,0xece0,0xe4c0,0xe4a0,0xdc80,0xc400,
0x1a00,0x0280,0x0300,0x0360,0x03a0,0x0400,0x0440,0x0480,
0x04c0,0x0500,0x0540,0x0560,0x05a0,0x05c0,0x0600,0x0620,
0x0640,0x0660,0x0660,0x0680,0x0680,0x0680,0x1682,0x2e85,
0x2684,0x0680,0x06a0,0x06a0,0x06a0,0x06a0,0x0660,0x0640,
0x9cf3,0x94b2,0x8c31,0x636e,0x1332,0x0374,0x0374,0x0395,
0x0395,0x0395,0x0374,0x0374,0x0374,0x0353,0x0353,0x0353,
0x0333,0x0312,0x0312,0x02f1,0x02b0,0x026f,0x0a6e,0x0a4d,
0x1a0a,0x42ab,0x7c10,0x8c50,0x8c50,0x7bef,0x634c,0x738e,
0x6b8d,0x5acb,0x52ca,0x52ca,0x5acb,0x52ca,0x52ca,0x5acb,
0x52aa,0x52aa,0x528a,0x632c,0x738e,0x6b6d,0x634c,0x632c,
0x630c,0x630b,0x5aec,0x5aeb,0x2a26,0x4245,0x7a81,0x8b00,
0x9b20,0xa340,0xa382,0xb510,0xce58,0xcebc,0xcebc,0xce15,
0xcc84,0xd460,0xdc80,0xdc80,0xe4a0,0xe4c0,0xecc0,0xecc0,
0xecc0,0xecc0,0xece0,0xece0,0xed00,0xece0,0xf4e0,0xed00,
0xf500,0xf500,0xf500,0xf520,0xfd00,0xfd20,0xfd20,0xfd20,
0xf500,0xf500,0xf520,0xf520,0xfd20,0xfd20,0xf520,0xfd20,
0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xf520,
0xfd20,0xf520,0xf500,0xf500,0xf500,0xf4e0,0xf4e0,0xf4e0,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xed00,
0xece0,0xece0,0xecc0,0xece0,0xe4c0,0xdca0,0xdc60,0xc464,
0x63c9,0x0240,0x02c0,0x0320,0x0380,0x03c0,0x0400,0x0440,
0x0480,0x04c0,0x0500,0x0520,0x0560,0x0580,0x05c0,0x05e0,
0x0600,0x0620,0x0640,0x0640,0x0620,0x5deb,0xb6b6,0xd75a,
0xd79a,0x9ef3,0x1e23,0x0660,0x0640,0x0640,0x0620,0x05e0,
0x2352,0x230f,0x1aef,0x02d0,0x0333,0x0333,0x0353,0x0333,
0x0333,0x0333,0x0333,0x0312,0x02f1,0x02d1,0x02b0,0x0290,
0x028f,0x026e,0x0a6e,0x126d,0x228d,0x3aac,0x4acc,0x5acb,
0x528a,0x5289,0x8c51,0x8c51,0x8410,0x7bef,0x6b6c,0x7bcf,
0x6b8e,0x5b0b,0x5b0b,0x5aeb,0x5aec,0x5aca,0x5aca,0x5aeb,
0x52cb,0x5aab,0x52aa,0x634c,0x738e,0x6b4d,0x6b4d,0x632c,
0x630c,0x5b0c,0x5aeb,0x62ec,0x3266,0x0980,0x6a60,0x8ae0,
0x9b20,0x9b40,0xaccf,0xd6db,0xe73d,0xef5d,0xef5d,0xdf3e,
0xd5af,0xd440,0xdc80,0xdca0,0xe4a0,0xe4c0,0xecc0,0xece0,
0xecc0,0xecc0,0xece0,0xece0,0xece0,0xece0,0xed00,0xed00,
0xed00,0xf500,0xf500,0xf500,0xf500,0xf520,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf520,0xf520,0xf520,0xf500,0xf500,
0xf520,0xf520,0xf520,0xfd20,0xfd20,0xfd20,0xfd20,0xf520,
0xf520,0xfd00,0xf520,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xece0,0xece0,
0xece0,0xece0,0xecc0,0xecc0,0xe4a0,0xdc80,0xd420,0xcd0b,
0xf7bd,0x8550,0x0280,0x0300,0x0360,0x03a0,0x03e0,0x0420,
0x0460,0x04a0,0x04c0,0x0500,0x0520,0x0560,0x0580,0x05a0,
0x05c0,0x05c0,0x05e0,0x05a0,0x550a,0xbdb7,0xe6bc,0xf77e,
0xffbf,0xffdf,0x6e6e,0x05a0,0x05c0,0x05c0,0x05a0,0x0560,
0x12f1,0x02af,0x028f,0x028f,0x02b0,0x02b0,0x02b0,0x02b0,
0x0aaf,0x0aaf,0x1aaf,0x22ef,0x2b10,0x3b50,0x32ee,0x42ee,
0x4b2e,0x534e,0x636e,0x6b8e,0x736e,0x6b6d,0x6b4c,0x630c,
0x5acb,0x4a49,0x6b4d,0x8c51,0x8430,0x7bcf,0x738d,0x7c0f,
0x73ae,0x630c,0x632c,0x630c,0x5aeb,0x5aeb,0x52ca,0x5aca,
0x5acb,0x52aa,0x52aa,0x632c,0x738e,0x6b4d,0x632c,0x632c,
0x630c,0x5aec,0x5aeb,0x5aeb,0x3aa8,0x01c0,0x5220,0x8ac0,
0x9300,0x9b84,0xbdb6,0xdedb,0xe73c,0xef7e,0xf79e,0xef7d,
0xd677,0xd442,0xdc80,0xdc80,0xe4a0,0xe4a0,0xe4c0,0xe4c0,
0xecc0,0xecc0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xed00,0xece0,0xf4e0,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf500,0xf520,0xf520,0xfd20,0xfd20,
0xf520,0xfd20,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf500,0xed00,0xece0,0xece0,0xece0,
0xece0,0xecc0,0xe4c0,0xe4a0,0xdca0,0xd480,0xd420,0xcd6e,
0xffdf,0xf7be,0x3ba7,0x02e0,0x0340,0x0380,0x03c0,0x0400,
0x0440,0x0460,0x0480,0x04c0,0x04e0,0x0500,0x0540,0x0540,
0x0560,0x0580,0x0580,0x2484,0x8450,0xad35,0xc638,0xdedb,
0xdf1c,0xf73f,0x7e0f,0x0520,0x0560,0x0560,0x0540,0x04e0,
0x9536,0x84d4,0x7cb4,0x7c73,0x7473,0x6c53,0x6c53,0x7494,
0x84b4,0x8cf4,0x9d14,0xa534,0xad55,0xad54,0x840f,0x840f,
0x8410,0x8410,0x83ef,0x7bcf,0x73ae,0x738e,0x6b6d,0x6b2d,
0x630c,0x52aa,0x528a,0x8430,0x8430,0x73ae,0x73ae,0x7bef,
0x73ce,0x632b,0x632c,0x632c,0x62ec,0x5aeb,0x5aca,0x52aa,
0x52aa,0x52aa,0x528a,0x632c,0x738e,0x6b4d,0x632c,0x632c,
0x5b0c,0x630b,0x5aeb,0x5acb,0x42a8,0x0200,0x3200,0x82c0,
0x92e0,0x93a6,0xb5b6,0xd69a,0xe71c,0xef3d,0xef7e,0xe71d,
0xce58,0xcc63,0xd460,0xdc80,0xdca0,0xe4a0,0xe4a0,0xe4a0,
0xe4c0,0xe4c0,0xece0,0xecc0,0xece0,0xece0,0xece0,0xece0,
0xece0,0xece0,0xece0,0xece0,0xece0,0xed00,0xed00,0xed00,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,0xf500,
0xf500,0xf500,0xece0,0xece0,0xece0,0xece0,0xecc0,0xecc0,
0xe4c0,0xe4c0,0xe4a0,0xe4a0,0xdc80,0xd460,0xcc20,0xc54e,
0xe71c,0xef5d,0x4c09,0x02c0,0x0320,0x0360,0x03a0,0x03c0,
0x0400,0x0420,0x0460,0x0480,0x04c0,0x04c0,0x0500,0x0500,
0x0500,0x0520,0x0520,0x2bc5,0x7b8f,0x94b2,0xad55,0xbdd7,
0xc5f8,0xbdd7,0x3507,0x0520,0x0520,0x0500,0x0480,0x2483,
0xc618,0xc5f7,0xc5f7,0xc5f7,0xc5f7,0xbdd6,0xbdd6,0xbdb6,
0xbd96,0xb575,0xad75,0xad55,0xa535,0xa514,0x8430,0x7bef,
0x8410,0x8410,0x8410,0x7bf0,0x7bcf,0x73ae,0x738e,0x6b6d,
0x6b4d,0x630c,0x4a69,0x6b6d,0x8430,0x738e,0x7bef,0x7bcf,
0x73ae,0x632c,0x6b6d,0x632c,0x630c,0x5aeb,0x5acb,0x52aa,
0x52aa,0x5289,0x52aa,0x630c,0x738e,0x6b4d,0x632c,0x630b,
0x5aeb,0x5acb,0x5acb,0x5acb,0x42a8,0x0220,0x1200,0x7a80,
0x8ae0,0x8b43,0xa514,0xc618,0xce9a,0xdedb,0xd6da,0xd67a,
0xbdb5,0xc422,0xd440,0xd460,0xdc80,0xdca0,0xdca0,0xe4a0,
0xe4c0,0xe4c0,0xe4c0,0xe4c0,0xecc0,0xecc0,0xecc0,0xece0,
0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xece0,0xece0,0xece0,0xece0,0xece0,0xf500,0xece0,0xf4e0,
0xf500,0xf500,0xf500,0xf500,0xece0,0xece0,0xece0,0xece0,
0xece0,0xece0,0xece0,0xecc0,0xecc0,0xe4c0,0xe4c0,0xe4c0,
0xe4a0,0xe4a0,0xdca0,0xdc80,0xdc60,0xd440,0xc400,0xb4ed,
0xce5a,0xc5f8,0x32c5,0x0260,0x02c0,0x0340,0x0380,0x03a0,
0x03e0,0x0400,0x0420,0x0440,0x0480,0x04a0,0x04a0,0x04c0,
0x04e0,0x04e0,0x04c0,0x13e1,0x4308,0x6b6e,0x83f0,0x8c51,
0x7c8f,0x34a6,0x04c0,0x04e0,0x0460,0x0420,0x44e8,0xcef8,
0xb5d6,0xb596,0xb596,0xad75,0xad76,0xad75,0xad55,0xad55,
0xad54,0xa534,0xa534,0xa534,0xa514,0x9cf4,0x8c51,0x8430,
0x8450,0x8c51,0x8c51,0x8430,0x83f0,0x7bcf,0x7bae,0x738e,
0x6b6d,0x632c,0x52aa,0x5acb,0x7bef,0x7bce,0x7bef,0x7bcf,
0x73ae,0x632c,0x6b6d,0x632c,0x630c,0x5aeb,0x5acb,0x528a,
0x528a,0x5269,0x5289,0x5b0b,0x73ae,0x632c,0x630c,0x5aeb,
0x5acb,0x5acb,0x5acb,0x52ab,0x42a8,0x0240,0x0200,0x5240,
0x8ac0,0x92e0,0x8bec,0xa555,0xb5d7,0xbe17,0xbdf7,0xb5b7,
0xa4af,0xbbe0,0xcc40,0xd440,0xd460,0xdc80,0xdc80,0xdc80,
0xdca0,0xdca0,0xe4a0,0xe4a0,0xe4a0,0xe4c0,0xe4c0,0xe4c0,
0xe4c0,0xe4a0,0xe4c0,0xe4c0,0xe4c0,0xecc0,0xecc0,0xecc0,
0xecc0,0xecc0,0xecc0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,0xece0,
0xece0,0xecc0,0xecc0,0xe4c0,0xe4a0,0xe4a0,0xdca0,0xdca0,
0xdc80,0xdca0,0xdc80,0xd480,0xd460,0xcc40,0xc3e0,0xa44c,
0x9d15,0x6b6e,0x3a07,0x3266,0x1a63,0x02a1,0x02e0,0x0340,
0x0380,0x03c0,0x03e0,0x0400,0x0420,0x0440,0x0460,0x0480,
0x0480,0x0480,0x0480,0x0460,0x0be1,0x1b82,0x1bc3,0x1c04,
0x0c42,0x0460,0x0420,0x0400,0x2c85,0x9612,0xef9d,0xffdf,
0xb5b7,0xb596,0xb596,0xad75,0xad75,0xad55,0xa554,0xa554,
0xa535,0xa534,0xa534,0xa513,0xa513,0x9cf3,0x8c51,0x8c51,
0x8c51,0x8c71,0x8c71,0x8c51,0x8430,0x840f,0x7bef,0x7bcf,
0x738e,0x6b6d,0x630c,0x528a,0x738d,0x7bef,0x7bcf,0x7bcf,
0x73ae,0x632c,0x738d,0x630c,0x5aeb,0x5aeb,0x52aa,0x528a,
0x528a,0x4a6a,0x528a,0x52ab,0x738e,0x6b4d,0x630c,0x5aeb,
0x5aca,0x5acb,0x52aa,0x52ab,0x4288,0x0260,0x0240,0x1a00,
0x7aa0,0x92e0,0x8b02,0x83cd,0x94b3,0x9d14,0xa534,0x94b3,
0xa3e6,0xbbe0,0xc420,0xcc20,0xd440,0xd460,0xd460,0xdc80,
0xdc80,0xdc80,0xdc80,0xdca0,0xdc80,0xdca0,0xdca0,0xdca0,
0xdca0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,
0xe4a0,0xe4c0,0xe4c0,0xe4c0,0xe4c0,0xe4c0,0xe4c0,0xe4c0,
0xecc0,0xecc0,0xe4c0,0xe4c0,0xe4c0,0xe4c0,0xe4c0,0xecc0,
0xe4c0,0xecc0,0xecc0,0xecc0,0xece0,0xecc0,0xecc0,0xecc0,
0xecc0,0xe4c0,0xe4a0,0xe4a0,0xdc80,0xdc80,0xdc80,0xdc80,
0xdc80,0xdc80,0xd460,0xd440,0xcc40,0xc420,0xbbe0,0x7329,
0x4a8b,0x4208,0x526a,0x5aab,0x5aeb,0x530a,0x3b07,0x1ae4,
0x0ae1,0x0300,0x0320,0x0360,0x03a0,0x03c0,0x0400,0x0420,
0x0420,0x0440,0x0440,0x0440,0x0420,0x0420,0x0400,0x0400,
0x03c0,0x1402,0x44c8,0x95f2,0xdf3b,0xffbf,0xf79f,0xf79e,
0xb5b6,0xb596,0xad75,0xad75,0xad55,0xad55,0xad35,0xa534,
0xa534,0xa514,0xa514,0xa514,0x9cf3,0x9cf3,0x8c71,0x8c71,
0x9491,0x9492,0x9492,0x8c71,0x8c51,0x8431,0x8410,0x7bcf,
0x73ae,0x738e,0x6b4d,0x528a,0x630c,0x7bef,0x7bcf,0x7bcf,
0x738e,0x632c,0x6b6d,0x632c,0x62ec,0x5aeb,0x5acb,0x52aa,
0x4a88,0x4268,0x4aa9,0x4268,0x5aeb,0x6b6d,0x632d,0x5aec,
0x5a8a,0x528a,0x4a8a,0x528a,0x4287,0x0280,0x0240,0x0200,
0x5221,0x8ae0,0x9300,0x8b21,0x7b27,0x7b8d,0x7bad,0x8369,
0xab80,0xbbe0,0xc3e0,0xcc20,0xcc20,0xcc40,0xcc40,0xcc60,
0xd460,0xd460,0xd460,0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,
0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,0xdca0,0xe4a0,0xdc80,
0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,
0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,0xe4a0,
0xe4a0,0xe4a0,0xe4a0,0xe4c0,0xe4c0,0xe4a0,0xe4c0,0xe4c0,
0xe4a0,0xe4a0,0xe4a0,0xdca0,0xdc80,0xdc80,0xd460,0xd460,
0xd460,0xd440,0xcc40,0xcc20,0xcc00,0xc400,0xa381,0x4a06,
0x4229,0x4a6a,0x52aa,0x5aeb,0x6b2d,0x738e,0x7baf,0x7bcf,
0x6bad,0x7c8f,0x74ee,0x546a,0x3c07,0x2bc5,0x1ba3,0x13a2,
0x0b81,0x0b81,0x0b81,0x0bc2,0x1be3,0x2c25,0x44a8,0x6d4d,
0x9e13,0xceb9,0xef5d,0xf79e,0xf77e,0xef5d,0xef7d,0xef7d,
0xb596,0xad75,0xad75,0xad55,0xad55,0xad55,0xa534,0xa534,
0xa514,0xa514,0x9cf4,0x9cf4,0x9cf3,0x94d2,0x9491,0x9492,
0x94b2,0x94b2,0x94b2,0x94b2,0x9492,0x8c51,0x8430,0x7bef,
0x7bcf,0x73ae,0x6b6d,0x5aeb,0x5acb,0x7bcf,0x73ae,0x6b6e,
0x632c,0x5aeb,0x62ec,0x62ec,0x5aec,0x4ac9,0x3286,0x2264,
0x0a62,0x0221,0x0a41,0x0a21,0x0a01,0x2a65,0x3a88,0x52aa,
0x528a,0x4a49,0x4a49,0x528a,0x3a67,0x0280,0x0280,0x0220,
0x21a3,0x7241,0x92e0,0x9300,0x9300,0x8ac0,0x8b01,0xa340,
0xaba0,0xb3c0,0xbbc0,0xbbe0,0xc400,0xc400,0xcc20,0xcc20,
0xcc40,0xcc40,0xcc40,0xd440,0xd440,0xd460,0xd460,0xd460,
0xd460,0xd460,0xd460,0xd480,0xd480,0xdc80,0xdc80,0xdc80,
0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,
0xdca0,0xdca0,0xdc80,0xdc60,0xdc60,0xdc40,0xdc60,0xdc80,
0xdc80,0xdca0,0xdc80,0xdca0,0xdca0,0xdca0,0xdca0,0xdc80,
0xdc80,0xdc80,0xdc80,0xdc80,0xd460,0xd460,0xd460,0xcc40,
0xcc40,0xcc40,0xcc20,0xc400,0xc400,0xbbe0,0x7ae4,0x4229,
0x4a69,0x52aa,0x5aeb,0x632d,0x736e,0x73ae,0x7c0f,0x8430,
0x8c31,0xbdd7,0xdebb,0xd69b,0xd69a,0xce79,0xbe58,0xbe37,
0xadf5,0xa5d3,0xa614,0xb636,0xc698,0xdeda,0xef3d,0xf75d,
0xf75d,0xef5d,0xe73d,0xef5c,0xef5d,0xef7d,0xef5d,0xef7d,
0xb596,0xad75,0xad55,0xad55,0xa534,0xa534,0xa534,0xa514,
0xa513,0x9cf3,0x9cf3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x94b2,
0x94b3,0x9cd3,0x9cd3,0x94b2,0x9492,0x8c71,0x8c51,0x8430,
0x7bef,0x7bcf,0x738e,0x632c,0x52aa,0x632c,0x630c,0x62ec,
0x5aeb,0x630c,0x52ca,0x3ac7,0x22a3,0x0aa1,0x0a81,0x1282,
0x1a83,0x1a63,0x1242,0x0a61,0x0260,0x0240,0x01e0,0x11e2,
0x3206,0x4a08,0x4208,0x4a49,0x3a67,0x0280,0x0280,0x0240,
0x0982,0x39a4,0x7aa1,0x8b00,0x9320,0x9b40,0xa340,0xa360,
0xaba0,0xb3a0,0xb3e0,0xb3e0,0xbbe0,0xc400,0xc400,0xc400,
0xc420,0xcc20,0xcc20,0xcc20,0xcc20,0xcc40,0xcc40,0xcc40,
0xcc40,0xcc40,0xd440,0xd460,0xd460,0xd460,0xd460,0xd460,
0xd460,0xd460,0xd460,0xd480,0xd480,0xdc80,0xd460,0xdc60,
0xdc80,0xd460,0xd440,0xd4c4,0xd549,0xd549,0xd4c4,0xd440,
0xd460,0xd460,0xd460,0xdc80,0xdc80,0xdc80,0xdc80,0xdc80,
0xd460,0xd460,0xd460,0xd460,0xd460,0xcc40,0xcc40,0xcc20,
0xcc20,0xcc00,0xc400,0xbbe0,0xb3e0,0xaba1,0x5a66,0x426a,
0x528a,0x5acb,0x632c,0x6b6d,0x73ce,0x7c0f,0x8411,0x8c51,
0x8c71,0xb5d6,0xc638,0xc638,0xce59,0xce79,0xd69a,0xdebb,
0xdedc,0xe6fc,0xe6fc,0xe71c,0xdefc,0xe6fc,0xdefb,0xe6fb,
0xdf1c,0xe71c,0xe73c,0xe73c,0xe73c,0xef5d,0xef5d,0xef5d,
0xb596,0xad55,0xad54,0xa535,0xa534,0xa534,0xa514,0xa4f4,
0x9cf3,0x9cf3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x94b2,0x9cd3,
0x9cd3,0x9cf3,0x9cf3,0x9cd3,0x94b2,0x9492,0x8c71,0x8c51,
0x8410,0x7bef,0x73ae,0x6b4d,0x52ab,0x5acb,0x630c,0x62ec,
0x630c,0x42c8,0x22a3,0x1ac3,0x2ac5,0x42a8,0x4aa9,0x4aa9,
0x4a89,0x4a4a,0x4228,0x3a07,0x3225,0x1242,0x0260,0x0240,
0x01c0,0x2184,0x39e7,0x4228,0x3246,0x0280,0x02a0,0x0260,
0x09c1,0x2965,0x49e5,0x7aa1,0x9300,0x9b20,0x9b40,0xa360,
0xab60,0xab80,0xb3a0,0xb3c0,0xbbe0,0xbbe0,0xbbe0,0xbc00,
0xc3e0,0xc400,0xc400,0xc400,0xcc20,0xcc20,0xcc20,0xcc20,
0xcc20,0xcc40,0xcc20,0xcc40,0xcc40,0xcc40,0xcc40,0xd440,
0xd440,0xd440,0xd440,0xd440,0xd460,0xd440,0xd460,0xd460,
0xd440,0xcc62,0xddf1,0xf75b,0xffbd,0xffbe,0xf77a,0xd58d,
0xcc20,0xd440,0xd440,0xd440,0xd460,0xd440,0xd460,0xd460,
0xd440,0xd440,0xcc40,0xcc40,0xcc40,0xcc20,0xcc20,0xcc20,
0xc400,0xbbe0,0xbbe0,0xbbc0,0xb3c0,0x7ae4,0x4a48,0x528a,
0x52aa,0x630c,0x6b4d,0x73ae,0x7bef,0x8430,0x8c71,0x9492,
0x94b2,0xb5b6,0xc618,0xc638,0xc638,0xce59,0xce59,0xce79,
0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,
0xdefb,0xe71c,0xe71c,0xe73c,0xef5d,0xe73c,0xe73c,0xef5d,
0x9512,0xb556,0xad35,0xa534,0xa514,0xa514,0xa513,0x9cf3,
0x9cf3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x94b2,0x9cd3,0x9cf3,
0x9cf3,0xa514,0xa514,0x9cf3,0x9cd3,0x94b2,0x9492,0x8c51,
0x8431,0x840f,0x7bce,0x736d,0x5acb,0x52aa,0x630b,0x52ea,
0x32a6,0x2aa5,0x3ac7,0x5aca,0x5acb,0x5acb,0x5a8b,0x528a,
0x528a,0x4a69,0x4a29,0x4a08,0x4a29,0x4228,0x1a23,0x0280,
0x0260,0x01a0,0x2165,0x4209,0x3246,0x0280,0x02a0,0x0260,
0x01c0,0x2145,0x31a7,0x49e4,0x72a1,0x9300,0x9320,0x9b40,
0x9b60,0xab60,0xab80,0xab80,0xb3a0,0xb3c0,0xb3e0,0xbbc0,
0xbbc0,0xbbe0,0xbbe0,0xc3e0,0xc400,0xc400,0xc400,0xc400,
0xc400,0xcc00,0xc420,0xcc20,0xcc20,0xcc20,0xcc20,0xcc20,
0xcc20,0xcc20,0xcc20,0xcc20,0xcc40,0xcc40,0xcc40,0xcc20,
0xc400,0xcd90,0xef5e,0xf7df,0xffff,0xffff,0xf7df,0xdefb,
0xbc44,0xcc00,0xcc20,0xcc20,0xcc20,0xcc40,0xcc40,0xcc40,
0xcc20,0xcc40,0xcc20,0xcc20,0xcc00,0xc400,0xc400,0xc400,
0xbbe0,0xbbc0,0xb3c0,0xb3a0,0x9342,0x5247,0x4a4a,0x52aa,
0x5acb,0x632c,0x738e,0x7bcf,0x8410,0x8c51,0x9492,0x94b2,
0x9cd3,0xb5b6,0xbdf7,0xc618,0xc638,0xc638,0xce59,0xce59,
0xce79,0xd69a,0xd69a,0xd69a,0xd6ba,0xdedb,0xdedb,0xdefb,
0xdefb,0xdefb,0xe71c,0xe71c,0xe73c,0xe73c,0xe73c,0xef5d,
0x546a,0x6c4c,0xa555,0xad55,0xa514,0xa513,0xa514,0x9cf3,
0x9cd3,0x9cd3,0x94b2,0x94b2,0x9492,0x94b2,0x9cf3,0x9cf3,
0xa514,0xa514,0xa514,0xa514,0x9cf3,0x9cd3,0x94b2,0x8c71,
0x8c51,0x8410,0x7bcf,0x736d,0x62eb,0x52aa,0x4ac9,0x32a6,
0x42c8,0x5acb,0x5aab,0x52cb,0x5acb,0x528a,0x528a,0x528a,
0x4a69,0x4a69,0x4a48,0x4a49,0x4a49,0x4a4a,0x4228,0x0a41,
0x02a0,0x0240,0x0941,0x3186,0x21e4,0x0280,0x02c0,0x0260,
0x01c0,0x2144,0x39a7,0x29a6,0x19e1,0x5ac0,0x8ae0,0x9b00,
0x9b40,0xa340,0xa360,0xab80,0xab80,0xaba0,0xb3a0,0xb3c0,
0xb3c0,0xb3c0,0xbbc0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xc400,
0xc3e0,0xc400,0xc400,0xc400,0xc400,0xc400,0xc400,0xc400,
0xc400,0xc420,0xc420,0xc420,0xcc20,0xc420,0xc420,0xc400,
0xb3e3,0xbdd6,0xd6bb,0xe71b,0xe73c,0xe73c,0xdefb,0xc639,
0xb425,0xc400,0xcc20,0xcc20,0xcc20,0xc420,0xcc20,0xcc00,
0xc420,0xc420,0xc420,0xc400,0xc400,0xc400,0xbbe0,0xbbc0,
0xb3c0,0xb3a0,0xaba0,0x9b41,0x5a86,0x4249,0x4a89,0x52ab,
0x630c,0x6b6d,0x73ae,0x8410,0x8c51,0x9492,0x94b2,0x9cf3,
0x9cf3,0xb5b6,0xbdd7,0xbdf7,0xc618,0xc638,0xc638,0xce59,
0xce59,0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,
0xdefb,0xdefb,0xe71c,0xe71c,0xe73c,0xe73c,0xe73c,0xef5d,
0xad75,0x4408,0x43c8,0x9d13,0xad35,0x9cf3,0x9cf4,0x9cf3,
0x9cd3,0x94b2,0x94b2,0x9492,0x8c71,0x9cd3,0x9cf3,0xa514,
0xa514,0xa534,0xa534,0xa514,0x9cf3,0x9cd3,0x94b2,0x9492,
0x8c51,0x8410,0x7bef,0x73ae,0x632d,0x4a89,0x3a88,0x5aca,
0x5acb,0x5aaa,0x528a,0x52ab,0x52aa,0x5289,0x528a,0x4a8a,
0x4a8a,0x4a69,0x4a49,0x4a49,0x4a49,0x4a69,0x4a4a,0x2265,
0x02a0,0x02a0,0x0180,0x2125,0x1983,0x02c0,0x02e0,0x0260,
0x01c0,0x1944,0x2985,0x0a21,0x02a0,0x0a80,0x4201,0x7a81,
0x92e0,0x9b20,0x9b40,0xa340,0xa360,0xa380,0xab80,0xaba0,
0xb3a0,0xb3a0,0xb3c0,0xb3c0,0xb3c0,0xb3c0,0xbbc0,0xbbc0,
0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbc00,0xc3e0,
0xc400,0xc400,0xc400,0xc400,0xc400,0xc400,0xc400,0xbbe0,
0xabc2,0x9cd2,0xb5d7,0xc618,0xc659,0xc639,0xb5f8,0xaccf,
0xb3c2,0xc3e0,0xc400,0xc400,0xc400,0xc400,0xc400,0xc3e0,
0xc400,0xc3e0,0xbbe0,0xbbe0,0xbbe0,0xbbc0,0xb3c0,0xb3a0,
0xaba0,0xab80,0xa340,0x6aa5,0x4228,0x4a69,0x528a,0x5acb,
0x630c,0x6b6d,0x7bcf,0x8430,0x8c71,0x94b2,0x9cd3,0x9cf3,
0xa514,0xb596,0xbdd7,0xbdd7,0xbdf7,0xc618,0xc638,0xc638,
0xce59,0xce79,0xce79,0xce79,0xd69a,0xd6ba,0xd6ba,0xdedb,
0xdedb,0xdefb,0xdefb,0xe71c,0xe71c,0xe71c,0xe73c,0xef5d,
0xad75,0xa554,0x3c07,0x2b64,0x94d2,0xa535,0x9cd3,0x9cd3,
0x9cd3,0x94b2,0x9492,0x8c71,0x8c71,0x9cf3,0xa514,0xa534,
0xa534,0xa534,0xa534,0xa534,0xa514,0x9cf3,0x9cd3,0x9492,
0x8c71,0x8c50,0x8410,0x73af,0x634c,0x52aa,0x5a6a,0x52ab,
0x52aa,0x528a,0x528a,0x528a,0x528a,0x528a,0x528a,0x528a,
0x528a,0x4a69,0x4a49,0x4a49,0x4a4a,0x528a,0x5269,0x4268,
0x3265,0x2204,0x21a4,0x2966,0x21a4,0x0aa0,0x02e0,0x02a0,
0x09c1,0x2945,0x11c2,0x02c0,0x02c0,0x0220,0x1984,0x41e6,
0x6244,0x82a2,0x8b00,0x9320,0x9b40,0xa340,0xa360,0xa360,
0xab80,0xab80,0xaba0,0xaba0,0xaba0,0xb3a0,0xb3a0,0xb3a0,
0xb3c0,0xb3c0,0xbbc0,0xb3c0,0xbbe0,0xbbc0,0xbbc0,0xbbc0,
0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbc0,
0xb3a0,0x93a8,0x8c50,0x94b3,0x94d3,0x9492,0x942c,0xab82,
0xbbc0,0xbbe0,0xbc00,0xbbe0,0xbbe0,0xbbe0,0xbbe0,0xbbe0,
0xbbe0,0xbbc0,0xbbc0,0xb3c0,0xb3c0,0xb3a0,0xaba0,0xaba0,
0xa360,0x9b40,0x8368,0x4a6a,0x4a49,0x4a69,0x5aab,0x5b0b,
0x632c,0x738e,0x7bef,0x8c51,0x9492,0x9cd3,0x9cf3,0xa534,
0xa534,0xb596,0xb5b6,0xb5b6,0xbdd7,0xbdf7,0xc618,0xc638,
0xc638,0xce59,0xce59,0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,
0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,0xe71c,0xe73c,0xe73c,
0xad55,0xad35,0xa554,0x23c4,0x1b04,0x8cb1,0xa4f4,0x9cd3,
0x94b2,0x94b2,0x9492,0x8c71,0x8c71,0x9cf3,0xa534,0xa534,
0xad55,0xad55,0xad55,0xad55,0xa534,0xa514,0x9cd3,0x94b2,
0x9472,0x8c51,0x8410,0x7bcf,0x6b6d,0x52aa,0x4a69,0x4a69,
0x5289,0x4a89,0x4a89,0x528a,0x528a,0x4a6a,0x5289,0x528a,
0x4a89,0x4a8a,0x4a69,0x4a69,0x4a49,0x528a,0x52aa,0x4a69,
0x4a49,0x4208,0x39e7,0x39c7,0x39c7,0x3206,0x2a64,0x2a25,
0x31c5,0x2965,0x0a41,0x0300,0x0280,0x0a01,0x39c7,0x4229,
0x4a69,0x5268,0x6285,0x7aa2,0x8ae0,0x9b00,0x9b40,0xa340,
0xa340,0xa360,0xa360,0xab80,0xab80,0xaba0,0xaba0,0xaba0,
0xb3a0,0xb3a0,0xb3a0,0xb3a0,0xb3c0,0xb3c0,0xb3c0,0xb3c0,
0xb3c0,0xb3c0,0xb3c0,0xb3c0,0xb3c0,0xb3c0,0xb3c0,0xb3c0,
0xb3c0,0xab80,0x9362,0x8b46,0x8b65,0x9b63,0xa380,0xbba0,
0xbbc0,0xb3c0,0xb3c0,0xbbc0,0xb3c0,0xbbc0,0xb3c0,0xb3c0,
0xb3c0,0xb3a0,0xb3a0,0xaba0,0xab80,0xab80,0xa360,0x9b20,
0x8b01,0x838a,0x634d,0x4a49,0x4a69,0x52aa,0x5aca,0x630c,
0x6b6d,0x73ae,0x8410,0x8c71,0x94b2,0x9cf3,0xa514,0xad55,
0xad55,0xad75,0xb596,0xb5b6,0xbdd7,0xbdd7,0xbdf7,0xc618,
0xc638,0xc638,0xce59,0xce79,0xce79,0xd69a,0xd69a,0xd6ba,
0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,0xe71c,0xe71c,0xe73c,
0xad55,0xa514,0xad34,0x9d12,0x1362,0x22e4,0x94b1,0x9cf3,
0x94b2,0x9492,0x8c71,0x8c51,0x9492,0xa514,0xa534,0xad55,
0xad75,0xad75,0xad75,0xad75,0xad55,0xa514,0x9cf3,0x9cd3,
0x9492,0x8c71,0x8430,0x7bce,0x6b6d,0x5acb,0x4a49,0x4a49,
0x4a49,0x4a69,0x4a69,0x4a89,0x5289,0x5289,0x528a,0x528a,
0x528a,0x528a,0x4a89,0x528a,0x4a6a,0x52aa,0x52aa,0x4a89,
0x4268,0x4248,0x4a49,0x4a49,0x4a48,0x4249,0x4248,0x4228,
0x39e7,0x3986,0x29e5,0x1a43,0x2244,0x3a47,0x4a49,0x4a69,
0x4a69,0x4a8a,0x52ab,0x52a9,0x62a6,0x7aa2,0x82c0,0x9300,
0x9320,0x9b20,0xa340,0xa360,0xa360,0xa360,0xa360,0xa380,
0xab80,0xab80,0xab80,0xab80,0xaba0,0xaba0,0xb3a0,0xaba0,
0xb3a0,0xb3a0,0xb3a0,0xb3a0,0xb3a0,0xb3a0,0xb3c0,0xb3c0,
0xb3a0,0xb3a0,0xb3a0,0xab80,0xab80,0xb380,0xb3a0,0xb3c0,
0xb3a0,0xb3a0,0xb3a0,0xb3a0,0xb3c0,0xb3a0,0xb3a0,0xaba0,
0xaba0,0xab80,0xab80,0xa360,0xa340,0x9b40,0x9321,0x82e5,
0x736c,0x6b6e,0x52ab,0x4a49,0x526a,0x52aa,0x5aeb,0x632c,
0x6b6d,0x7bcf,0x8430,0x8c71,0x9cd3,0x9cf3,0xa534,0xad55,
0xad75,0xad75,0xad75,0xb596,0xb5b6,0xbdd7,0xbdf7,0xbdf7,
0xc618,0xc638,0xce59,0xce59,0xce79,0xce79,0xd69a,0xd6ba,
0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,0xe71c,0xe71c,
0xb576,0xa535,0xa514,0xad35,0x74ae,0x0300,0x2ac5,0x94b3,
0x94b2,0x9492,0x8c71,0x8430,0x94b2,0xa534,0xa534,0xad55,
0xad75,0xad75,0xad75,0xad75,0xad55,0xa534,0xa514,0x9cd3,
0x94b2,0x8c71,0x8430,0x7bef,0x738e,0x5aeb,0x4a49,0x4a49,
0x4a49,0x4a69,0x4a69,0x5269,0x528a,0x528a,0x528a,0x528a,
0x528a,0x528a,0x52aa,0x528a,0x52a9,0x52aa,0x52aa,0x4a89,
0x5289,0x4aaa,0x52aa,0x528a,0x5289,0x4a69,0x4a69,0x4248,
0x4228,0x4208,0x4208,0x4228,0x4a68,0x4a89,0x528a,0x528a,
0x528a,0x528a,0x52aa,0x52aa,0x52cb,0x630b,0x5ae7,0x6282,
0x7ac2,0x82c1,0x8ae0,0x9300,0x9b00,0x9b20,0x9b40,0x9b40,
0xa360,0xa360,0xa360,0xa360,0xab80,0xab60,0xab80,0xab80,
0xab80,0xab80,0xab80,0xab80,0xab80,0xab80,0xaba0,0xaba0,
0xaba0,0xab80,0xaba0,0xab80,0xaba0,0xaba0,0xab80,0xab80,
0xab80,0xab80,0xab80,0xab80,0xaba0,0xa380,0xab80,0xab60,
0xa360,0xa360,0x9b40,0x9b20,0x9300,0x8304,0x7b49,0x6b8e,
0x6b4d,0x5aeb,0x4a69,0x4a69,0x528a,0x5aab,0x5aec,0x6b4c,
0x738e,0x7bef,0x8430,0x9492,0x9cd3,0x9cf3,0xa534,0xad55,
0xad75,0xad75,0xad75,0xad75,0xb596,0xb5b6,0xbdd7,0xbdf7,
0xc618,0xc638,0xce59,0xce79,0xce79,0xd69a,0xd6ba,0xd6ba,
0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,0xe71c,0xe71c,
0x9533,0x9d13,0xa514,0xad15,0xad55,0x4408,0x0260,0x4308,
0x9cb3,0x8c71,0x8c51,0x8410,0x94d2,0xa514,0xad54,0xad75,
0xad75,0xad75,0xad75,0xad75,0xad55,0xa534,0xa514,0x9cf3,
0x94b2,0x8c71,0x8c51,0x7bef,0x738e,0x632c,0x4a49,0x4208,
0x4a49,0x4a69,0x4a69,0x528a,0x528a,0x52aa,0x52aa,0x52aa,
0x52aa,0x52aa,0x52aa,0x52aa,0x52aa,0x52aa,0x52ca,0x52ca,
0x52ca,0x5aca,0x5acb,0x52aa,0x52aa,0x4a89,0x4a89,0x4a69,
0x4a69,0x4a69,0x4a69,0x5289,0x52a9,0x52aa,0x52aa,0x52aa,
0x52aa,0x52aa,0x52aa,0x52aa,0x5aeb,0x632c,0x632c,0x530b,
0x6b0b,0x6ae8,0x6ac6,0x72a4,0x7ac2,0x82c0,0x8ac0,0x8ae0,
0x92e0,0x9300,0x9b20,0x9b40,0xa360,0xa360,0xa360,0xa360,
0xa360,0xa360,0xa360,0xa360,0xa380,0xa360,0xa360,0xa360,
0xab80,0xa360,0xab80,0xab80,0xa360,0xab80,0xa360,0xa360,
0xa360,0xa360,0xa360,0xa360,0xa360,0xa360,0x9b40,0x9b40,
0x9b20,0x9300,0x8ae1,0x8305,0x736a,0x738e,0x738e,0x6b6d,
0x630c,0x528a,0x4a69,0x528a,0x52aa,0x5acb,0x630c,0x6b4d,
0x73ae,0x7bef,0x8430,0x9491,0x94d3,0x9cf4,0xa514,0xa534,
0xad35,0xad95,0xad75,0xad75,0xb596,0xb5b6,0xbdd7,0xc618,
0xce39,0xce59,0xce39,0xc638,0xc638,0xc658,0xce79,0xce79,
0xd69a,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,0xe71c,
0x23a4,0x2344,0x3b87,0x5beb,0x8490,0x8cb1,0x1362,0x01e0,
0x636c,0x8c72,0x8410,0x8410,0x9cd2,0xa514,0xa534,0xad75,
0xb596,0xb596,0xb596,0xb596,0xad75,0xad55,0xa534,0x9cf3,
0x94b2,0x9492,0x8c51,0x8410,0x73ae,0x6b4d,0x4a69,0x39c7,
0x4228,0x4a69,0x4a69,0x528a,0x528a,0x52aa,0x52aa,0x5acb,
0x5acb,0x5acb,0x5acb,0x5acb,0x52ca,0x5aca,0x5aea,0x5aeb,
0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5acb,0x52ca,0x52ca,0x4aa9,
0x5289,0x52aa,0x52aa,0x52aa,0x52ca,0x52ca,0x5acb,0x5acb,
0x5acb,0x5acb,0x5aaa,0x5acb,0x630c,0x632c,0x632c,0x632c,
0x632c,0x634d,0x632d,0x632c,0x736c,0x7b8b,0x7b6a,0x7b27,
0x7b05,0x7ac3,0x82c0,0x82c0,0x8ac0,0x8ac0,0x92e0,0x9300,
0x9b20,0x9b20,0x9b20,0x9b40,0x9b40,0xa340,0x9b40,0x9b40,
0xa340,0xa360,0xa360,0xa360,0xa360,0xa360,0x9b40,0x9b40,
0x9b40,0x9b20,0x9b20,0x9320,0x9300,0x8ae0,0x8ae0,0x8ac0,
0x7b04,0x7b47,0x7b8b,0x73cf,0x73cf,0x73ae,0x736d,0x6b4d,
0x5aeb,0x4a69,0x4a69,0x528a,0x5acb,0x5aeb,0x632c,0x6b6d,
0x73ce,0x7bef,0x8431,0x8c71,0x94b2,0x9cd3,0x9cf3,0xa514,
0xa514,0xa554,0xad55,0xa534,0xb596,0xbdf7,0xbdf8,0xad95,
0x8d11,0x74ce,0x6ced,0x7d2e,0x8d51,0x95b3,0xa5d4,0xbe37,
0xce79,0xd69a,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,0xe71c,
0x74ae,0x3be7,0x0341,0x02e0,0x12e2,0x3b47,0x2365,0x0260,
0x11c2,0x7bcf,0x7bcf,0x7c0f,0x9cb3,0xa4f3,0xa534,0xad55,
0xad75,0xb596,0xb596,0xb596,0xad75,0xad55,0xa534,0xa514,
0x9cd3,0x9492,0x8c71,0x8430,0x7bcf,0x6b6d,0x52aa,0x39c7,
0x4208,0x4a69,0x528a,0x528a,0x52aa,0x52aa,0x5acb,0x5aeb,
0x5aeb,0x5acb,0x5acb,0x5acb,0x5acb,0x5aeb,0x5b0b,0x632c,
0x632c,0x630c,0x630c,0x630c,0x5aeb,0x5aea,0x52ea,0x52ca,
0x52cb,0x5acb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
0x5aeb,0x5acb,0x5acb,0x62ec,0x632c,0x632c,0x632c,0x630c,
0x630c,0x630c,0x630c,0x632c,0x73cf,0x8431,0x8451,0x8451,
0x8c50,0x8c2f,0x840d,0x83cc,0x838a,0x7b48,0x8326,0x7ae4,
0x82c2,0x82c2,0x82c1,0x82c1,0x82c0,0x82c0,0x8ac0,0x8ac0,
0x8ac0,0x8ac0,0x8ac0,0x8ac0,0x8ac0,0x8ac0,0x8ac0,0x8ac0,
0x82c0,0x82c0,0x82c1,0x82c2,0x7ae4,0x7b26,0x7b49,0x7b8c,
0x7bce,0x7bf0,0x7bd0,0x73cf,0x73ae,0x738e,0x6b6e,0x6b4d,
0x630c,0x4a69,0x528a,0x52aa,0x5acb,0x630c,0x6b4d,0x738e,
0x7bcf,0x7c0f,0x8430,0x8c51,0x9492,0x94b2,0x9cd3,0x9cd3,
0x94b2,0xa4f3,0xad55,0xad55,0xad55,0x84b0,0x43c8,0x3366,
0x4c08,0x74ce,0x9573,0xa5f5,0xb636,0xc637,0xc658,0xce79,
0xce79,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,
0xb576,0xa534,0x94f2,0x542a,0x0b61,0x02e0,0x02a0,0x0240,
0x0140,0x3a07,0x6b4d,0x7bcf,0x8c72,0x9d13,0xa554,0xad75,
0xad75,0xb596,0xb596,0xb596,0xad75,0xad55,0xa534,0xa514,
0x9cd3,0x9492,0x8c71,0x8430,0x7bcf,0x6b6d,0x5acb,0x39c7,
0x4208,0x4a49,0x528a,0x52aa,0x52aa,0x5acb,0x5aeb,0x5aeb,
0x5aec,0x5aeb,0x5aeb,0x5aeb,0x5b0b,0x630b,0x630c,0x632c,
0x632d,0x632c,0x632c,0x632c,0x630c,0x5b0b,0x5b0b,0x5aeb,
0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5b0b,0x5b0b,0x5aeb,0x5aeb,
0x630c,0x5aeb,0x5b0b,0x632c,0x632c,0x632c,0x632c,0x630c,
0x630c,0x630b,0x5aeb,0x6b4d,0x7bef,0x8430,0x8c51,0x8c71,
0x8c92,0x9492,0x94b3,0x94b2,0x94b2,0x9492,0x8c71,0x8c71,
0x8c30,0x840f,0x83ee,0x7bad,0x7b8c,0x6b29,0x6b29,0x6b08,
0x7308,0x7308,0x7308,0x7308,0x7328,0x7328,0x7328,0x7328,
0x734a,0x7b8b,0x7bad,0x7bae,0x7bef,0x7bef,0x7bf0,0x7bf0,
0x7bf0,0x7bef,0x7bce,0x7bcf,0x73ae,0x73ae,0x738e,0x6b6d,
0x632c,0x528a,0x4a49,0x5acb,0x5aeb,0x632c,0x6b6d,0x738e,
0x7bcf,0x7bcf,0x7c10,0x8c30,0x8450,0x7c2f,0x8c71,0x8c51,
0x8451,0x9472,0xa514,0x63cc,0x2304,0x0aa1,0x43c7,0x9511,
0xb5d6,0xbe17,0xc638,0xce39,0xce59,0xce59,0xce79,0xce9a,
0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,
0xad54,0xa514,0xa534,0xa514,0x848f,0x2384,0x0320,0x02a0,
0x01a0,0x1943,0x630c,0x738e,0x8c51,0x9cf3,0xa534,0xad55,
0xad75,0xb596,0xb596,0xb596,0xad75,0xad55,0xa534,0xa514,
0x9cf3,0x94b2,0x8c71,0x8430,0x7bef,0x738e,0x5aeb,0x39c7,
0x4229,0x526a,0x528a,0x5aaa,0x5acb,0x5aeb,0x5aeb,0x630c,
0x62ec,0x5aeb,0x630b,0x632c,0x632c,0x630c,0x630c,0x6b4d,
0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x632b,0x632b,0x630b,
0x630c,0x630c,0x5aeb,0x630c,0x5b0b,0x5b0b,0x630b,0x5b0b,
0x630c,0x630c,0x630c,0x6b4d,0x6b4d,0x632c,0x632c,0x632c,
0x630c,0x630c,0x5acb,0x6b6d,0x8410,0x8430,0x8c51,0x8c71,
0x9492,0x9492,0x94b2,0x94b2,0x94b2,0x94b2,0x9492,0x9493,
0x9492,0x8c92,0x8c71,0x8431,0x8430,0x73af,0x6b6e,0x738e,
0x73af,0x73ae,0x73af,0x73cf,0x7bcf,0x7bcf,0x7bef,0x7bf0,
0x7bf0,0x7bf0,0x7c10,0x7c10,0x7bf0,0x7bf0,0x7bf0,0x7bef,
0x7bef,0x7bef,0x7bcf,0x7bef,0x7bcf,0x73ae,0x73ae,0x738e,
0x6b4d,0x5acb,0x528a,0x4a69,0x630c,0x6b4d,0x738e,0x73ae,
0x7bcf,0x7bcf,0x7bcf,0x7bef,0x3b07,0x5bab,0x83f0,0x7bae,
0x7bae,0x5b0c,0x2a85,0x0220,0x0ae1,0x74ae,0xbd96,0xbdb7,
0xb5b7,0xbdd7,0xbdf7,0xc618,0xc638,0xce59,0xce59,0xce79,
0xce79,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xad76,0xa534,0x9d13,0x9cd3,0x9cd3,0x8491,0x1b63,0x0320,
0x0260,0x19c3,0x5aab,0x630c,0x8c51,0x9cd3,0xa513,0xa555,
0xad75,0xb596,0xb596,0xb596,0xad75,0xad75,0xa534,0xa514,
0x9cf3,0x9cd3,0x8c71,0x8430,0x7bef,0x73ae,0x5acb,0x4228,
0x526a,0x52ab,0x5acb,0x5acb,0x5aeb,0x5aec,0x630c,0x630c,
0x632c,0x632c,0x634c,0x634c,0x632c,0x632d,0x6b2d,0x6b6d,
0x6b6d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x634c,0x634c,0x632c,
0x632c,0x632c,0x630c,0x630c,0x630c,0x632c,0x632c,0x5aeb,
0x630b,0x630c,0x6b2d,0x6b4d,0x6b4d,0x634c,0x632c,0x630c,
0x630c,0x5aeb,0x5aeb,0x73ae,0x8430,0x8c51,0x8c71,0x9492,
0x94b2,0x94b2,0x9cd3,0x9cd3,0x94d3,0x94d3,0x94b2,0x94b2,
0x94b2,0x9492,0x8c71,0x8c51,0x8431,0x7bcf,0x6b4d,0x6b6d,
0x6b6e,0x738e,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x7bcf,
0x7bcf,0x7bef,0x7bef,0x7bef,0x7bf0,0x83f0,0x7bef,0x7bef,
0x7bef,0x7bef,0x7bef,0x7bef,0x7bcf,0x7bcf,0x7bcf,0x73ae,
0x6b6d,0x630c,0x5aeb,0x52aa,0x528a,0x630c,0x6b6d,0x7bcf,
0x7bcf,0x73af,0x736e,0x532a,0x1aa3,0x5b8b,0x6b2d,0x52aa,
0x3a86,0x09e1,0x0220,0x0aa0,0x3b87,0x7c4e,0x8d11,0xad75,
0xb5b6,0xb5d6,0xbdf7,0xc618,0xc618,0xc658,0xce59,0xce79,
0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdefb,0xdefb,
0xb595,0xa534,0xa514,0xa514,0x9cb3,0x9c92,0x6c0d,0x0360,
0x02e0,0x01c0,0x2184,0x6b2d,0x8c51,0x8c91,0x9cd3,0xa534,
0xad55,0xb596,0xb596,0xb596,0xb596,0xad75,0xa534,0xa514,
0x9cf3,0x9cd3,0x9492,0x8c51,0x8410,0x6b6d,0x528a,0x528a,
0x5aab,0x5acb,0x5aec,0x62ec,0x630c,0x630c,0x632c,0x632d,
0x634c,0x6b4d,0x6b6d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b6d,
0x6b6d,0x6b6d,0x6b6d,0x6b6d,0x6b4d,0x6b4c,0x634c,0x634c,
0x6b4d,0x6b4d,0x632c,0x630c,0x632c,0x632c,0x632c,0x630c,
0x5b0b,0x632c,0x736d,0x6b6d,0x6b4d,0x6b4d,0x632c,0x632c,
0x630c,0x5aeb,0x630c,0x7bcf,0x8430,0x8c71,0x9491,0x94b2,
0x9cd2,0x9cd2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cb3,
0x94b3,0x94b2,0x9492,0x8c71,0x8430,0x8410,0x6b6d,0x6b4d,
0x6b6d,0x738e,0x73ae,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,
0x7bef,0x7bef,0x7bef,0x7bf0,0x7bef,0x8410,0x8410,0x7c10,
0x8410,0x7bef,0x7bf0,0x7bef,0x7bf0,0x7bef,0x7bcf,0x7bef,
0x738e,0x6b4d,0x6b4d,0x632c,0x5aeb,0x52aa,0x5acb,0x632c,
0x6b6d,0x6b4d,0x630c,0x1a83,0x1b23,0x52ca,0x3a27,0x0a21,
0x02a0,0x02c0,0x0300,0x544b,0x8cd1,0x84af,0x84d0,0x9512,
0xad95,0xbdd7,0xbdd7,0xc618,0xc638,0xc638,0xce58,0xce59,
0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xb596,0xad55,0xa555,0xa514,0x9cf3,0x94b2,0x9472,0x3bc7,
0x0360,0x02a0,0x0200,0x3286,0x6b4d,0x7bcf,0x8c71,0x9cf3,
0xad55,0xad75,0xb596,0xb596,0xad75,0xad75,0xa534,0xa514,
0x9cf3,0x94b2,0x9492,0x8c71,0x738e,0x5acb,0x5acb,0x630c,
0x630b,0x630c,0x630c,0x632d,0x6b2d,0x6b4d,0x6b4d,0x6b6d,
0x6b6d,0x6b6d,0x6b6d,0x6b6e,0x6b6d,0x6b6d,0x6b6d,0x6b6d,
0x738e,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x6b6c,0x6b4d,
0x6b6d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x632c,0x6b4c,0x632c,
0x632b,0x632c,0x738e,0x738e,0x6b6d,0x6b4d,0x6b4d,0x632c,
0x632c,0x5aec,0x632d,0x8410,0x8c51,0x9492,0x9492,0x9cb2,
0x9cd3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cd3,0x9cd3,0x94b2,0x8c71,0x8c51,0x8431,0x738e,0x6b4d,
0x6b6d,0x738e,0x73ae,0x73ae,0x73cf,0x7bcf,0x7bcf,0x7bef,
0x7bce,0x7bef,0x7bef,0x83f0,0x8410,0x840f,0x8410,0x8410,
0x8410,0x8410,0x8410,0x8410,0x8410,0x8410,0x7bf0,0x7bef,
0x738e,0x738e,0x6b6d,0x6b6d,0x6b4d,0x632c,0x5aeb,0x52aa,
0x528a,0x5249,0x29e5,0x0320,0x22e5,0x31a5,0x0220,0x0320,
0x0340,0x3b67,0x5bab,0x94d2,0xad35,0xb576,0xb576,0xad95,
0xadb6,0xbdd6,0xbdf7,0xc618,0xc618,0xce58,0xce59,0xce59,
0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xb596,0xad75,0xad55,0xa555,0xa514,0x9cf3,0x9cb3,0x4c2a,
0x0360,0x02e0,0x0280,0x0260,0x0a01,0x4268,0x8430,0x9cf3,
0xad55,0xad75,0xb596,0xb5b6,0xb596,0xad75,0xad55,0xa514,
0xa514,0x94b2,0x8430,0x6b6d,0x630c,0x632c,0x6b4d,0x632d,
0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b6d,0x6b6d,0x736e,0x738e,
0x736e,0x736e,0x738e,0x738e,0x738e,0x738e,0x73ae,0x7bef,
0x73ae,0x738e,0x738e,0x73ae,0x738e,0x6b8d,0x6b8d,0x6b8d,
0x738e,0x6b6d,0x6b6d,0x6b6d,0x6b4d,0x6b4d,0x6b4d,0x6b6d,
0x6b4d,0x632c,0x6b4c,0x738e,0x738e,0x6b6d,0x6b4d,0x6b4d,
0x632c,0x5aeb,0x6b6d,0x8430,0x8c71,0x9492,0x94b2,0x9cd3,
0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cf3,0x9cb3,0x94b2,0x9492,0x8c71,0x8430,0x7bcf,0x632c,
0x6b4d,0x6b8d,0x738e,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x7bcf,
0x7bef,0x7c0f,0x83f0,0x8410,0x7c10,0x8410,0x8410,0x8430,
0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x840f,
0x73ae,0x73ae,0x73ae,0x73ae,0x738e,0x738e,0x6b6d,0x6b4d,
0x632c,0x5aab,0x3266,0x1362,0x3ae7,0x2a05,0x0b40,0x2b85,
0x636c,0x73ee,0x8410,0x9492,0xa514,0xad54,0xad75,0xb596,
0xb5b6,0xbdd7,0xbdf7,0xc618,0xc618,0xc638,0xce59,0xce59,
0xce79,0xce79,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xb5b6,0xad75,0xad54,0xad35,0xa514,0xa4f4,0x7caf,0x0be1,
0x2b45,0x5b2b,0x3305,0x0300,0x02a0,0x3246,0x7bae,0x9cb3,
0xa534,0xb596,0xb5b6,0xb5b6,0xb596,0xad75,0xa514,0x9cd3,
0x8c51,0x7bcf,0x6b4d,0x6b4d,0x6b6d,0x6b6d,0x6b6d,0x738e,
0x736e,0x6b6d,0x736e,0x736e,0x738e,0x738e,0x73ae,0x73af,
0x7b8e,0x73ae,0x7baf,0x7bcf,0x8410,0x8410,0x8410,0x8410,
0x7bcf,0x73ae,0x73ae,0x73ae,0x73ae,0x73ae,0x6b8d,0x738d,
0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x6b6d,0x6b6d,0x6b6d,
0x6b6d,0x738e,0x6b4d,0x6b4d,0x738e,0x6b6d,0x6b6d,0x6b4d,
0x632c,0x5acb,0x738e,0x8c51,0x8c71,0x94b2,0x94b2,0x9cd3,
0x9cf3,0x9cf3,0xa514,0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cd3,0x9cd3,0x94b2,0x9492,0x8c71,0x8c51,0x7bef,0x632c,
0x634d,0x736d,0x6b8e,0x73ae,0x73ae,0x7bcf,0x7bef,0x7bef,
0x83ef,0x8410,0x8410,0x8430,0x8431,0x8c31,0x8c31,0x8c31,
0x8c51,0x8431,0x8c30,0x8430,0x8430,0x8450,0x8430,0x8410,
0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x73ae,
0x73ae,0x738e,0x6b8d,0x6b8c,0x736e,0x6b4d,0x63ac,0x73ee,
0x7c0f,0x8c91,0x8430,0x94b2,0xa513,0xad35,0xad76,0xb596,
0xb5b6,0xbdd7,0xbdf7,0xc618,0xc638,0xc638,0xce59,0xce59,
0xce79,0xce79,0xd69a,0xd69a,0xd6ba,0xdedb,0xdedb,0xdefb,
0xbdd7,0xad76,0xad75,0xa534,0xad34,0x9d13,0x2485,0x33c6,
0x7bef,0x8410,0x740e,0x4388,0x4348,0x632c,0x736e,0x73ae,
0x8410,0x8c51,0x8c51,0x8c71,0x8c51,0x8430,0x7bef,0x73ae,
0x73ae,0x73ae,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,
0x7bf0,0x7bef,0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x7baf,0x7baf,
0x7baf,0x83f0,0x8430,0x8430,0x8430,0x8430,0x8430,0x8430,
0x8430,0x7bef,0x7bcf,0x7bcf,0x7bcf,0x73ce,0x73ae,0x73ae,
0x73ae,0x73ae,0x73ae,0x738e,0x738e,0x738e,0x738e,0x738e,
0x738e,0x7bcf,0x7bcf,0x6b6d,0x6b6d,0x738e,0x738e,0x6b4d,
0x630c,0x5acb,0x7bcf,0x8c51,0x9492,0x9cd3,0x9cd3,0x9cf3,
0x9cf3,0xa514,0xa514,0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cf3,0x9cd3,0x9492,0x9492,0x8c51,0x8430,0x8410,0x6b4d,
0x6b4c,0x6b4d,0x738e,0x738e,0x73ae,0x7bcf,0x7bf0,0x8411,
0x8410,0x8410,0x7c0f,0x7c0f,0x740f,0x742f,0x7c2f,0x7c2f,
0x8c30,0x8c51,0x8c72,0x9472,0x8c71,0x8c51,0x8c51,0x8430,
0x7bef,0x8410,0x8410,0x8410,0x8410,0x8410,0x8410,0x8410,
0x8410,0x8410,0x7c0f,0x7bef,0x8410,0x7c0f,0x7c0f,0x8430,
0x8c51,0x9cd2,0x9491,0x94b1,0xa534,0xad55,0xad75,0xb596,
0xb5b6,0xbdd7,0xbdf7,0xc618,0xc618,0xc638,0xce59,0xce59,
0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xb5b7,0xb596,0xad75,0xad55,0xa534,0x6ced,0x2424,0x8470,
0x8471,0x9492,0x8c71,0x7baf,0x6bae,0x7bef,0x8411,0x840f,
0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x8410,0x8410,
0x8410,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bcf,0x8410,
0x8430,0x8c51,0x8c51,0x8c51,0x8c51,0x8430,0x8410,0x8410,
0x8430,0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,
0x8c51,0x8410,0x7bef,0x7bef,0x7bef,0x7bce,0x73ce,0x73ae,
0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x73ae,0x73ae,0x73ae,
0x738e,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x6b6d,0x6b6d,
0x632c,0x5acb,0x7bef,0x8c71,0x94b2,0x9cd3,0x9cf3,0x9cf3,
0xa514,0xa514,0xa514,0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cd3,0x94b2,0x9492,0x8c71,0x8c51,0x8430,0x8410,0x738e,
0x632c,0x6b4d,0x6b6d,0x738e,0x7bcf,0x7bf0,0x73ae,0x5b6a,
0x4367,0x2b45,0x1b43,0x1362,0x1382,0x1ba3,0x23c4,0x33e6,
0x3c07,0x4c28,0x544a,0x6c4d,0x8470,0x8c71,0x9492,0x8450,
0x8410,0x8430,0x8430,0x8430,0x8430,0x8430,0x8c51,0x8c51,
0x8c51,0x8c51,0x8430,0x8450,0x8c71,0x8c71,0x8450,0x8c91,
0x8c71,0x9cf3,0xa514,0x9cd3,0x9cf3,0xad55,0xad75,0xb596,
0xb5b6,0xbdd7,0xbdf7,0xc618,0xc618,0xc638,0xc638,0xce59,
0xce79,0xce79,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdefb,
0xbdd7,0xb595,0xad75,0xad55,0xa534,0x34c6,0x7c6e,0x94d2,
0x94b2,0x9cf3,0x9491,0x7c0f,0x7c0f,0x8430,0x8c71,0x9491,
0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,0x8c51,0x8c51,0x8c51,
0x8430,0x8430,0x8430,0x8410,0x8410,0x8410,0x7bef,0x8410,
0x8c71,0x8c51,0x8c71,0x8c51,0x8c71,0x8c71,0x8c71,0x8c71,
0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,
0x8c71,0x8430,0x7c10,0x7bef,0x7bef,0x7bef,0x7bce,0x7bcf,
0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x73ae,
0x738e,0x6b6d,0x6b4d,0x6b4d,0x6b4d,0x6b2d,0x632c,0x632c,
0x630c,0x5aeb,0x7bef,0x9492,0x94b2,0x9cd3,0x9cf3,0xa514,
0xa514,0xa514,0xa514,0xa514,0x9cf3,0x9cf3,0x9cd3,0x9cd3,
0x94b2,0x94b2,0x8c92,0x8c51,0x8430,0x7bef,0x7bcf,0x738e,
0x632c,0x6b4d,0x6b6d,0x73ae,0x6b8d,0x3b07,0x1ae2,0x0340,
0x0340,0x0380,0x1bc3,0x43e8,0x540a,0x642b,0x6c2d,0x744d,
0x6c4d,0x744e,0x6c4d,0x6c4d,0x748e,0x7c8f,0x8c91,0x8c51,
0x8430,0x8c51,0x8c51,0x8c51,0x8c51,0x8c71,0x8c71,0x9492,
0x9492,0x8c91,0x8c51,0x94b2,0x9cd3,0x94b2,0x8c91,0x94d2,
0x94d2,0xa514,0xad35,0xad55,0xa534,0xa534,0xb595,0xb596,
0xb5b6,0xbdd7,0xbdd7,0xc618,0xc638,0xc638,0xce59,0xce59,
0xce79,0xce79,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdefb,
0xbdd7,0xb596,0xad76,0xad75,0x8510,0x54ea,0x9d13,0x94d2,
0x9d13,0xa513,0x94d2,0x8450,0x8450,0x9491,0x9492,0x94b3,
0x94b2,0x9492,0x9492,0x9492,0x9492,0x9492,0x8c71,0x8c71,
0x8c71,0x8c71,0x8c51,0x8c51,0x8c51,0x8c51,0x8430,0x8c51,
0x9492,0x9492,0x9492,0x8c72,0x8c71,0x8c71,0x9491,0x9492,
0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x8c71,0x8c51,
0x8410,0x8410,0x8430,0x8430,0x8410,0x7bef,0x7bef,0x7bef,
0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bcf,0x7bcf,
0x73ae,0x738e,0x736d,0x6b6d,0x6b4d,0x6b4d,0x632c,0x62ec,
0x5acb,0x528a,0x738e,0x94b2,0x9cd3,0x9cf3,0x9cf3,0xa514,
0xa514,0xa534,0xa514,0xa514,0x9cf3,0x9cd3,0x94b2,0x9492,
0x9471,0x8c71,0x8c51,0x8430,0x83ef,0x73cf,0x73ae,0x6b6d,
0x630c,0x6b4d,0x736e,0x4b09,0x1261,0x02e0,0x0360,0x0b81,
0x3ba8,0x6c0d,0x8430,0x8c50,0x8c51,0x8c72,0x9472,0x9472,
0x9472,0x9472,0x9472,0x8c71,0x8c71,0x8c70,0x8c50,0x8c51,
0x8c51,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x94b2,0x94b2,
0x9cb3,0x8cb1,0x94d2,0x9d13,0xa4f4,0x9cf3,0x94b2,0x9cf3,
0x9cf3,0xa534,0xad55,0xad75,0xad96,0xad75,0xad75,0xb5b6,
0xbdd7,0xbdd7,0xbdf7,0xc618,0xc638,0xc638,0xce59,0xce59,
0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xbdd7,0xb596,0xb595,0xad75,0x6d2d,0x8d11,0x9d13,0xa534,
0xad54,0xa534,0x94d2,0x8c71,0x9491,0x9cd3,0x9cd3,0x9cf3,
0x9cf3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x9492,0x9492,
0x9492,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x8c51,0x8c71,
0x94b2,0x9492,0x9492,0x9492,0x9492,0x9492,0x94b2,0x94b2,
0x94b2,0x94b2,0x94b2,0x9492,0x8c71,0x8c31,0x8430,0x8410,
0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x7c0f,0x8410,
0x8410,0x8410,0x8410,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
0x7bcf,0x73ae,0x738e,0x738e,0x736d,0x6b4d,0x6b4d,0x632c,
0x62eb,0x5acb,0x5aeb,0x8430,0x9cf3,0x9cf3,0xa514,0xa514,
0xa534,0xa534,0xa514,0xa514,0x9cf3,0x9cd3,0x9492,0x8c51,
0x8c51,0x8c51,0x8430,0x83ef,0x7baf,0x6b8e,0x6b6d,0x632c,
0x6b0d,0x6b2d,0x4288,0x0200,0x0320,0x0380,0x2384,0x6bcd,
0x8410,0x8410,0x8410,0x8c31,0x8c51,0x8c51,0x8c51,0x8430,
0x8430,0x8410,0x8410,0x8430,0x8430,0x8431,0x8431,0x8c51,
0x8c71,0x8c71,0x9492,0x9492,0x94b2,0x94b2,0x9cd3,0x9cd3,
0x9cd3,0x94d2,0x94b3,0x9cd3,0x9cf3,0xa513,0x9d13,0x9d13,
0xa554,0xa534,0xad75,0xb596,0xb596,0xb5b6,0xb5b6,0xb5b6,
0xb5b6,0xbdd7,0xbdf7,0xc618,0xc638,0xce59,0xce59,0xce59,
0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,
0xbdf7,0xb5b7,0xb596,0xb596,0x756f,0x9d53,0xa554,0xad75,
0xad75,0xad55,0x9cd3,0x8cb1,0x9cf3,0x9cf3,0x9d13,0xa513,
0xa514,0xa514,0x9cd3,0x9cf3,0x9cd3,0x9cd3,0x94b2,0x94b2,
0x94b2,0x94b2,0x94b2,0x9492,0x9492,0x9492,0x8c71,0x9492,
0x94b2,0x94b2,0x94b2,0x94b2,0x94b3,0x94b2,0x94b2,0x94b3,
0x9cd3,0x94b2,0x9471,0x8c31,0x8430,0x8430,0x8430,0x8430,
0x8430,0x8410,0x8430,0x8c51,0x8c51,0x8430,0x8430,0x8430,
0x8430,0x8430,0x8430,0x8410,0x8410,0x8410,0x8410,0x7bef,
0x7bcf,0x73ae,0x73ae,0x738e,0x738e,0x738e,0x6b4d,0x6b4d,
0x632c,0x630c,0x630c,0x630c,0x8c51,0xa514,0xa534,0xa534,
0xa534,0xa534,0xa534,0xa514,0x9cf3,0x94b2,0x8c51,0x8410,
0x7bef,0x6b6d,0x6b6d,0x73ae,0x6b6d,0x632c,0x630c,0x5aab,
0x4aa9,0x3286,0x01e0,0x02a0,0x0380,0x23a4,0x73ce,0x83f0,
0x8410,0x8430,0x8c51,0x8451,0x8430,0x8410,0x7c0f,0x8410,
0x8410,0x8430,0x8430,0x8c51,0x8c50,0x8c51,0x8c51,0x8c72,
0x9492,0x9492,0x94b2,0x94b2,0x94b2,0x9cd3,0x9cd3,0x9cf3,
0x9cf3,0x94d3,0x94b2,0x94b2,0x94f3,0x9cf2,0x9cf3,0x9cf4,
0xad55,0xad75,0xb5b6,0xb5b6,0xb5b6,0xbdb6,0xbdd7,0xbdd7,
0xbdd7,0xbdf7,0xc618,0xc638,0xc638,0xce59,0xce59,0xce59,
0xce79,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdedb,0xdefb,
0xbe17,0xbdb7,0xbdd6,0xadb5,0x9d53,0xad74,0xb5b6,0xb596,
0xb596,0xad75,0x9cf3,0x94f3,0xa534,0xa534,0xa514,0xa534,
0xa534,0xa534,0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cd3,0x9cd3,
0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x9492,0x9cd3,
0x9cf3,0x9cd3,0x9cd3,0x9cd3,0x9cf3,0x9cd3,0x9cd3,0x9cb3,
0x9492,0x8c51,0x8c51,0x8c31,0x8c30,0x8c51,0x8c51,0x8c51,
0x8c31,0x8c30,0x8430,0x8c51,0x8c71,0x8c50,0x8430,0x8c50,
0x8c51,0x8c51,0x8430,0x8430,0x8430,0x8410,0x8410,0x8410,
0x7bef,0x7bcf,0x7baf,0x73ae,0x73ae,0x738e,0x738e,0x736d,
0x6b6d,0x6b2d,0x6b4d,0x632c,0x632c,0x7bcf,0x9cd3,0xad55,
0xb575,0xad74,0xa535,0xa513,0x9cf3,0x9492,0x8430,0x7baf,
0x42e9,0x0a81,0x1342,0x5349,0x630c,0x5acb,0x4a89,0x2204,
0x0261,0x0280,0x02c0,0x0300,0x0360,0x4389,0x8410,0x8410,
0x8430,0x8c51,0x8430,0x7bef,0x7bef,0x7bef,0x8410,0x8430,
0x8430,0x8c51,0x8c51,0x8c71,0x8c71,0x8c71,0x8c71,0x9492,
0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cf3,0x9cf3,0xa514,
0x9d13,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9d13,
0xa534,0xa554,0xb595,0xbdd7,0xbdd7,0xbdd7,0xbdd7,0xbdf7,
0xbdf7,0xc618,0xc638,0xc638,0xce59,0xce59,0xce79,0xce79,
0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,
0xbe18,0xbdf7,0xbdf7,0xad95,0xad95,0xb5d6,0xbdd7,0xb5b6,
0xb5b6,0xad75,0x9cf3,0xa534,0xad55,0xad55,0xad55,0xad55,
0xad55,0xad55,0xad55,0xa534,0xa514,0xa514,0x9cf3,0x9cf3,
0x9cf3,0x9cd3,0x9cf3,0x9cf3,0x9cd3,0x9cd3,0x94b2,0xa514,
0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cd3,0x9cb3,0x9471,
0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,
0x8c51,0x8c51,0x8c51,0x8c51,0x8c71,0x8c51,0x8c50,0x8c51,
0x8c51,0x8c51,0x8c51,0x8c51,0x8c51,0x8430,0x8430,0x8430,
0x8410,0x7bef,0x7bcf,0x7baf,0x7bae,0x73ae,0x738e,0x738e,
0x738e,0x6b6d,0x738e,0x738e,0x6b6d,0x632c,0x6b6d,0x8410,
0x9492,0xa534,0xad55,0xad55,0xa534,0x9cd3,0x8c51,0x6b6d,
0x12a2,0x0380,0x0380,0x2303,0x4a69,0x4a49,0x19c3,0x02a0,
0x0320,0x0a41,0x02a0,0x0380,0x3366,0x53cb,0x63ec,0x8450,
0x8c51,0x8430,0x8410,0x8410,0x8430,0x8430,0x8c51,0x8c51,
0x8c51,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x9492,0x94b2,
0x9cd3,0x9cd3,0x9cd3,0x9cf3,0xa514,0xa514,0xa514,0xa514,
0x9cf3,0x9cf3,0x9cf3,0x9d13,0xa513,0xa514,0xa534,0xa534,
0xa554,0xa554,0xad54,0xb595,0xbdd7,0xbdf7,0xbdf7,0xc617,
0xc618,0xc638,0xc638,0xce59,0xce59,0xce79,0xce79,0xce79,
0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdefb,0xdefb,
0xce39,0xc618,0xb5b6,0xb5b6,0xbdf7,0xbdd7,0xbdd7,0xb5b6,
0xbdd7,0xad75,0xa534,0xad75,0xad75,0xad75,0xad75,0xad75,
0xad75,0xad55,0xad55,0xa534,0xa534,0xa534,0xa514,0xa514,
0xa514,0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cd3,0x9cd3,0x9cf3,
0xa514,0xa514,0xa514,0xa514,0xa4f4,0x9cb3,0x9472,0x8c71,
0x8c71,0x9472,0x9492,0x9472,0x9471,0x8c71,0x8c71,0x8c71,
0x8c51,0x8c71,0x8c71,0x8c71,0x9492,0x8c71,0x8c71,0x8c71,
0x8c71,0x8c71,0x8c51,0x8c51,0x8c51,0x8c51,0x8430,0x8430,
0x8430,0x83ef,0x7bef,0x7bef,0x7bcf,0x7bcf,0x7bcf,0x73ae,
0x738e,0x738e,0x738e,0x73ae,0x73ae,0x738e,0x6b6d,0x6b6d,
0x6b6d,0x6b6e,0x73ae,0x7bcf,0x7bef,0x7bcf,0x738e,0x4308,
0x03a0,0x0380,0x0340,0x0b22,0x4248,0x29a5,0x0240,0x0380,
0x2344,0x4a89,0x42a8,0x4329,0x6b8d,0x8430,0x7c50,0x8450,
0x8430,0x8410,0x8430,0x8430,0x8c51,0x8c51,0x8c51,0x8c71,
0x8c71,0x9492,0x9492,0x9492,0x9492,0x94b2,0x94b2,0x9cd3,
0x9cd3,0x9cf3,0x9cf3,0xa514,0xa514,0xa534,0xa534,0xa534,
0xa514,0xa514,0xa514,0xa534,0xa534,0xa554,0xa555,0xa555,
0xad55,0xad75,0xad54,0xad75,0xb596,0xc618,0xc618,0xc618,
0xc638,0xc638,0xce59,0xce59,0xce59,0xce79,0xce79,0xd69a,
0xd69a,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdedb,0xdefb,
0xce58,0xbdf7,0xb5d6,0xc618,0xc618,0xc5f8,0xbdd7,0xbdd7,
0xbdd7,0xad55,0xad75,0xb5b6,0xb5b6,0xb596,0xad75,0xad55,
0xa534,0xa514,0xa514,0xa514,0xad55,0xa534,0xa534,0xa534,
0xa534,0xa514,0xa514,0xa514,0xa514,0x9cf3,0x9cd3,0x9cd3,
0x9cd3,0x9cd3,0xa514,0xa514,0x9cd3,0x9492,0x9492,0x9492,
0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9472,0x9471,
0x9471,0x8c71,0x9492,0x8c71,0x9492,0x9491,0x9491,0x9492,
0x9492,0x8c71,0x8c71,0x8c71,0x8c71,0x8c51,0x8c51,0x8c51,
0x8430,0x8410,0x83f0,0x83f0,0x83ef,0x7bef,0x7bef,0x7bcf,
0x7bae,0x73ae,0x73ae,0x7bcf,0x73ae,0x73ae,0x73ae,0x738e,
0x738e,0x738d,0x6b4d,0x630c,0x5aeb,0x5aab,0x528b,0x1342,
0x0ba1,0x0360,0x03c0,0x1b23,0x52ca,0x4288,0x1b04,0x1ba3,
0x5bab,0x738e,0x636c,0x6b6d,0x73ae,0x8430,0x8c71,0x8c50,
0x8430,0x8430,0x8c51,0x8c51,0x8c71,0x8c71,0x8c71,0x9492,
0x9492,0x9492,0x94b2,0x94b2,0x94b2,0x9cd3,0x9cd3,0x9cd3,
0x9cf3,0x9cf3,0xa514,0xa534,0xa534,0xa534,0xad55,0xa534,
0xa534,0xa534,0xa534,0xa534,0xad55,0xad55,0xad75,0xad75,
0xad75,0xad95,0xb595,0xad95,0xb595,0xbdd6,0xc638,0xc638,
0xce59,0xce59,0xce59,0xce79,0xce79,0xce79,0xd69a,0xd69a,
0xd69a,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,
0xc638,0xbe17,0xc638,0xc638,0xc618,0xc618,0xbe18,0xbdf7,
0xb5b6,0xad75,0xb5b6,0xb5b6,0xb596,0xad55,0xa534,0xa534,
0xa534,0xa534,0xa534,0xa534,0xad55,0xad55,0xad55,0xad55,
0xad55,0xa534,0xa534,0xa534,0xa534,0xa514,0x9cf3,0x9cf3,
0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cb3,0x94b2,0x94b2,
0x94b2,0x94b2,0x94b2,0x94b2,0x9492,0x9492,0x9492,0x9492,
0x9492,0x9492,0x9492,0x9492,0x94b2,0x94b2,0x94b2,0x9492,
0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,0x8c71,
0x8c51,0x8430,0x8430,0x8410,0x8410,0x8410,0x7bef,0x7bef,
0x7bcf,0x7bcf,0x7bcf,0x7bef,0x7bcf,0x7bcf,0x7bcf,0x7bcf,
0x73ae,0x73ad,0x738e,0x6b6e,0x6b6d,0x6b6d,0x5b4b,0x23e4,
0x4388,0x3b47,0x2b85,0x4b69,0x738e,0x738e,0x6b4d,0x6b6d,
0x7bf0,0x8410,0x73ad,0x73ce,0x7bef,0x8c51,0x8c72,0x8c50,
0x8c51,0x8c51,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x9492,
0x94b2,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cf3,0x9cd3,0x9cf3,
0xa514,0xa514,0xa534,0xa534,0xad55,0xa534,0xad55,0xa534,
0xa534,0xad55,0xad55,0xad55,0xad55,0xad75,0xad75,0xad95,
0xb595,0xad95,0xb5b5,0xb5b6,0xb5b6,0xb5b6,0xbdf7,0xce59,
0xce59,0xce79,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,
0xd6ba,0xdedb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,
0xc658,0xce59,0xce59,0xc638,0xc638,0xc638,0xc618,0xc618,
0xb5b6,0xbdd6,0xbdd6,0xad75,0xad55,0xad55,0xad55,0xad54,
0xad55,0xad55,0xad55,0xa534,0xad55,0xad75,0xad75,0xad75,
0xad75,0xad55,0xad55,0xad55,0xa534,0xa534,0x9cf3,0x9cf3,
0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cd3,0x9cd3,
0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x9cd3,0x94b2,
0x9cb2,0x94b2,0x94b2,0x94b2,0x94b2,0x94b2,0x9cd3,0x94b2,
0x94b2,0x94b2,0x9492,0x9492,0x9492,0x9492,0x9492,0x8c71,
0x8c71,0x8c51,0x8430,0x8430,0x8430,0x8430,0x8410,0x8410,
0x8410,0x7bef,0x7bef,0x8410,0x7bef,0x7bef,0x7bef,0x7bef,
0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x7bef,0x83f0,0x4c29,0x53e9,
0x73ee,0x7bae,0x7bce,0x7bcf,0x7baf,0x7bcf,0x73ce,0x73ce,
0x8430,0x8c51,0x8430,0x7c0f,0x7c2f,0x8c71,0x8c51,0x8c50,
0x8c71,0x8c71,0x9492,0x9492,0x9492,0x9492,0x94b2,0x94b2,
0x94b2,0x9cd3,0x9cd3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0xa514,
0xa514,0xa534,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
0xad55,0xad55,0xad75,0xad75,0xad75,0xad75,0xad96,0xb596,
0xb5b6,0xb5b6,0xb5b6,0xb5d6,0xb5d6,0xbdd6,0xbdd6,0xc638,
0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
0xd6ba,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,0xe71c,
0xce79,0xce59,0xce59,0xce59,0xce59,0xc638,0xc638,0xbdf7,
0xbdd7,0xbdd7,0xb596,0xad75,0xad75,0xad75,0xad75,0xad75,
0xad75,0xad55,0xad55,0xad55,0xad75,0xb596,0xad75,0xb596,
0xad75,0xad75,0xad75,0xad75,0xad55,0xa534,0xa514,0xa514,
0xa514,0xa514,0xa514,0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
0x9cd3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x94b2,0x9cd3,0x9cd3,
0x9cd3,0x9cd3,0x94b2,0x94b2,0x94b2,0x9492,0x9492,0x9492,
0x9492,0x8c71,0x8c51,0x8c51,0x8c51,0x8430,0x8430,0x8430,
0x8410,0x8430,0x8410,0x8410,0x8410,0x8410,0x8410,0x8410,
0x7c10,0x8410,0x840f,0x8430,0x8430,0x8c31,0x4c69,0x742e,
0x8410,0x7c0f,0x7c2f,0x840f,0x83ef,0x7bef,0x7bef,0x7c0f,
0x8430,0x8c71,0x9491,0x8c70,0x8450,0x8471,0x8c51,0x8c71,
0x9492,0x9492,0x94b2,0x94b2,0x94b2,0x94b2,0x9cd3,0x9cd3,
0x9cd3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0xa514,0xa514,0xa514,
0xa534,0xad55,0xad55,0xad55,0xad75,0xad75,0xad75,0xad55,
0xad75,0xad75,0xad75,0xb596,0xb596,0xb596,0xb5b6,0xb5b6,
0xb5b6,0xb5d6,0xbdd7,0xbdd7,0xbdf7,0xbdd7,0xbdd7,0xc618,
0xce79,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,
0xd69a,0xce79,0xce79,0xce59,0xce59,0xce59,0xc618,0xbdd7,
0xb5b7,0xb5b6,0xb5b6,0xb596,0xb596,0xad96,0xb596,0xad75,
0xad75,0xad75,0xad75,0xad75,0xb596,0xb596,0xb596,0xb596,
0xb596,0xad75,0xad75,0xad75,0xad55,0xad55,0xa534,0xa534,
0xa514,0xa514,0xa514,0xa514,0xa514,0xa514,0xa514,0x9cf3,
0xa514,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,0x9cf3,
0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cf3,0x9cf3,
0x9cd3,0x9cd3,0x9cd3,0x94b2,0x94b2,0x94b2,0x94b2,0x94b2,
0x9492,0x9492,0x9492,0x8c71,0x8c71,0x8c51,0x8c51,0x8430,
0x8430,0x8430,0x8430,0x8430,0x8430,0x8430,0x8430,0x8430,
0x8430,0x8431,0x8c50,0x8c51,0x8c71,0x7c50,0x6c4d,0x8470,
0x842f,0x8430,0x8450,0x8430,0x8430,0x8410,0x8430,0x8450,
0x8c50,0x8c31,0x8c71,0x94b2,0x8cb1,0x8c91,0x8c91,0x9491,
0x94b2,0x94b2,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cf3,
0x9cf3,0xa514,0xa514,0xa514,0xa514,0xa534,0xa514,0xa534,
0xad55,0xad55,0xad55,0xad55,0xad75,0xad75,0xad75,0xad75,
0xad75,0xad75,0xb596,0xb596,0xb596,0xb5b6,0xb5b6,0xb5b6,
0xb5d6,0xbdd7,0xbdd7,0xbdf7,0xbdf7,0xbdf7,0xbdf7,0xc618,
0xd69a,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xdedb,
0xdedb,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xe71c
};
#endif
